/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.TypeAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.LiveLocalStoreAnalysis;
import edu.umd.cs.findbugs.ba.LiveLocalStoreDataflow;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.type.TypeAnalysis;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumberSourceInfo;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.detect.UnreadFieldsData;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.Type;

public class DontIgnoreResultOfPutIfAbsent
implements Detector {
    static final boolean countOtherCalls = false;
    final BugReporter bugReporter;
    final BugAccumulator accumulator;
    final ClassDescriptor concurrentMapDescriptor = DescriptorFactory.createClassDescriptor(ConcurrentMap.class);
    static final boolean DEBUG = false;
    static HashSet<String> immutableClassNames = new HashSet();

    public DontIgnoreResultOfPutIfAbsent(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.accumulator = new BugAccumulator(bugReporter);
    }

    public void report() {
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        ConstantPool pool = javaClass.getConstantPool();
        boolean found = false;
        for (Constant constantEntry : pool.getConstantPool()) {
            ConstantNameAndType nt;
            if (!(constantEntry instanceof ConstantNameAndType) || !(nt = (ConstantNameAndType)constantEntry).getName(pool).equals("putIfAbsent")) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        for (Method method : methodList = javaClass.getMethods()) {
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Error analyzing " + method.toString(), e);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error analyzing " + method.toString(), e);
            }
        }
    }

    private static int getPriorityForBeingMutable(Type type) {
        if (type instanceof ArrayType) {
            return 1;
        }
        if (type instanceof ObjectType) {
            String superClassName;
            UnreadFieldsData unreadFields = AnalysisContext.currentAnalysisContext().getUnreadFieldsData();
            ClassDescriptor cd = DescriptorFactory.getClassDescriptor((ObjectType)type);
            String className = cd.getClassName();
            if (immutableClassNames.contains(className)) {
                return 3;
            }
            XClass xClass = AnalysisContext.currentXFactory().getXClass(cd);
            if (xClass == null) {
                return 5;
            }
            ClassDescriptor superclassDescriptor = xClass.getSuperclassDescriptor();
            if (superclassDescriptor != null && (superClassName = superclassDescriptor.getClassName()).equals("java/lang/Enum")) {
                return 3;
            }
            boolean hasMutableField = false;
            boolean hasUpdates = false;
            for (XField xField : xClass.getXFields()) {
                String signature;
                if (xField.isStatic()) continue;
                if (!xField.isFinal() && !xField.isSynthetic()) {
                    hasMutableField = true;
                    if (unreadFields.isWrittenOutsideOfInitialization(xField)) {
                        hasUpdates = true;
                    }
                }
                if (!(signature = xField.getSignature()).startsWith("Ljava/util/concurrent") && !signature.startsWith("Ljava/lang/StringB") && signature.charAt(0) != '[' && signature.indexOf("Map") < 0 && signature.indexOf("List") < 0 && signature.indexOf("Set") < 0) continue;
                hasUpdates = true;
                hasMutableField = true;
            }
            if (!(hasMutableField || xClass.isInterface() || xClass.isAbstract())) {
                return 3;
            }
            if (hasUpdates || className.startsWith("java/util") || className.indexOf("Map") >= 0 || className.indexOf("List") >= 0) {
                return 1;
            }
            return 2;
        }
        return 5;
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws DataflowAnalysisException, CFGBuilderException {
        if (method.isSynthetic() || (method.getAccessFlags() & 0x40) == 64) {
            return;
        }
        JavaClass javaClass = classContext.getJavaClass();
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        LiveLocalStoreDataflow llsaDataflow = classContext.getLiveLocalStoreDataflow(method);
        MethodGen methodGen = classContext.getMethodGen(method);
        CFG cfg = classContext.getCFG(method);
        ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
        TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
        String sourceFileName = javaClass.getSourceFileName();
        Iterator<Location> i = cfg.locationIterator();
        block0: while (i.hasNext()) {
            boolean isImmediateNullTest;
            String signature;
            Location location = i.next();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (!(ins instanceof InvokeInstruction)) continue;
            InvokeInstruction invoke = (InvokeInstruction)ins;
            String className = invoke.getClassName(cpg);
            if (!invoke.getMethodName(cpg).equals("putIfAbsent") || !(signature = invoke.getSignature(cpg)).equals("(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;") || invoke instanceof INVOKESTATIC || !this.extendsConcurrentMap(className)) continue;
            InstructionHandle next = handle.getNext();
            boolean isIgnored = next != null && next.getInstruction() instanceof POP;
            boolean bl = isImmediateNullTest = next != null && (next.getInstruction() instanceof IFNULL || next.getInstruction() instanceof IFNONNULL);
            if (!isIgnored) continue;
            BitSet live = (BitSet)((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).getFactAtLocation(location);
            ValueNumberFrame vna = ((ValueNumberAnalysis)vnaDataflow.getAnalysis()).getFactAtLocation(location);
            ValueNumber vn = (ValueNumber)vna.getTopValue();
            int locals = vna.getNumLocals();
            boolean isRetained = false;
            for (int pos = 0; pos < locals; ++pos) {
                BugAnnotation ba;
                if (!((ValueNumber)vna.getValue(pos)).equals(vn) || !live.get(pos) || (ba = ValueNumberSourceInfo.findAnnotationFromValueNumber(method, location, vn, (ValueNumberFrame)vnaDataflow.getFactAtLocation(location), "VALUE_OF")) == null) continue;
                String pattern = "RV_RETURN_VALUE_OF_PUTIFABSENT_IGNORED";
                if (!isIgnored) {
                    pattern = "UNKNOWN";
                }
                Type type = (Type)((TypeFrame)((TypeAnalysis)typeDataflow.getAnalysis()).getFactAtLocation(location)).getTopValue();
                int priority = DontIgnoreResultOfPutIfAbsent.getPriorityForBeingMutable(type);
                BugInstance bugInstance = new BugInstance(this, pattern, priority).addClassAndMethod(methodGen, sourceFileName).addCalledMethod(methodGen, invoke).add(new TypeAnnotation(type)).add(ba);
                SourceLineAnnotation where = SourceLineAnnotation.fromVisitedInstruction(classContext, method, location);
                this.accumulator.accumulateBug(bugInstance, where);
                isRetained = true;
                continue block0;
            }
        }
        this.accumulator.reportAccumulatedBugs();
    }

    private boolean extendsConcurrentMap(@DottedClassName String className) {
        if (className.equals("java.util.concurrent.ConcurrentHashMap") || className.equals(this.concurrentMapDescriptor.getDottedClassName())) {
            return true;
        }
        ClassDescriptor c = DescriptorFactory.createClassDescriptorFromDottedClassName(className);
        Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
        try {
            if (subtypes2.isSubtype(c, this.concurrentMapDescriptor)) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        return false;
    }

    static {
        immutableClassNames.add("java/lang/Integer");
        immutableClassNames.add("java/lang/Long");
        immutableClassNames.add("java/lang/String");
        immutableClassNames.add("java/util/Comparator");
    }
}

