package de.ugoe.cs.quest.commands.usage;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.usageprofiles.FirstOrderMarkovModel;
import de.ugoe.cs.quest.usageprofiles.HighOrderMarkovModel;
import de.ugoe.cs.quest.usageprofiles.ModelFlattener;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to flatten high-order models and create first-order markov models
 * with the same stochastic properties.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDflattenModel implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String modelname;
		String modelnameFOM;

		try {
			modelname = (String) parameters.get(0);
			modelnameFOM = (String) parameters.get(1);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		Object dataObject = GlobalDataContainer.getInstance()
				.getData(modelname);
		if (dataObject == null) {
			CommandHelpers.objectNotFoundMessage(modelname);
			return;
		}
		if (!(dataObject instanceof HighOrderMarkovModel)) {
			CommandHelpers.objectNotType(modelname, "HighOrderMarkovModel");
			return;
		}

		HighOrderMarkovModel model = (HighOrderMarkovModel) dataObject;
		ModelFlattener flattener = new ModelFlattener();
		FirstOrderMarkovModel modelFOM = flattener
				.flattenHighOrderMarkovModel(model);

		if (GlobalDataContainer.getInstance().addData(modelnameFOM, modelFOM)) {
			CommandHelpers.dataOverwritten(modelnameFOM);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "flattenModel <modelname> <modelname_flattened>";
	}
}
