package de.ugoe.cs.quest.usability;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.util.console.Console;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 16.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class UsabilityEvaluationManager {
    
    /** */
    private List<UsabilityEvaluationRule> rules = new ArrayList<UsabilityEvaluationRule>();

    /**
     * TODO: comment
     * 
     */
    public UsabilityEvaluationManager() {
        super();
        init();
    }

    /**
     * TODO: comment
     * 
     */
    private void init() {
        rules.add(new TextInputStatisticsRule());
    }

    /**
     * TODO: comment
     * 
     * @param taskTree
     */
    public UsabilityEvaluationResult evaluateUsability(ITaskTree taskTree) {
        Console.traceln(Level.INFO, "evaluating usability of task tree " + taskTree);

        List<UsabilityEvaluationResult> results = new ArrayList<UsabilityEvaluationResult>();

        for (UsabilityEvaluationRule rule : rules) {
            Console.traceln(Level.INFO, "applying rule " + rule.getClass().getSimpleName());
            UsabilityEvaluationResult result = rule.evaluate(taskTree);
            results.add(result);
            Console.traceln(Level.INFO, "the rule found " + result.getAllDefects().size() +
                            " usability defects, of which " + result.getSevereDefects().size() +
                            " are severe.");
        }

        UsabilityEvaluationResult result = mergeResults(results);
        Console.println("the evaluation result contains " + result.getAllDefects().size() +
                        " defects, of which " + result.getSevereDefects().size() + " are severe.");
        return result;
    }

    /**
     * TODO: comment
     * 
     * @param results
     * @return
     */
    private UsabilityEvaluationResult mergeResults(List<UsabilityEvaluationResult> results) {
        UsabilityEvaluationResult result = new UsabilityEvaluationResult();

        for (UsabilityEvaluationResult ruleResult : results) {
            for (UsabilityDefect defect : ruleResult.getAllDefects()) {
                result.addDefect(defect);
            }
        }

        return result;
    }

}
