package de.ugoe.cs.quest.commands.misc;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.FileOutputListener;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to stop a {@link FileOutputListener}.
 * </p>
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDstopFileListener implements Command {

	@Override
	public void run(List<Object> parameters) {
		String filename;
		try {
			filename = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		Object dataObject = GlobalDataContainer.getInstance().getData(filename);
		if( dataObject==null ) {
			CommandHelpers.objectNotFoundMessage(filename);
			return;
		}
		if( !(dataObject instanceof FileOutputListener) ) {
			CommandHelpers.objectNotType(filename, "FileOutputListener");
			return;
		}
		
		FileOutputListener listener = (FileOutputListener) dataObject;
		listener.stop();
		GlobalDataContainer.getInstance().removeData(filename);
	}

	@Override
	public String help() {
		return "stopFileListener <filename>";

	}

}
