package de.ugoe.cs.quest.plugin.mfc.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.quest.plugin.mfc.LogPreprocessor;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to pre-process a single file.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDconvertToXml implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "convertToXml <sourceFile> <targetFile> {<base64>}";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		if (parameters.size() < 2) {
			throw new InvalidParameterException();
		}
		String source = (String) parameters.get(0);
		String target = (String) parameters.get(1);
		boolean base64 = false;
		if (parameters.size() == 3) {
			base64 = Boolean.parseBoolean((String) parameters.get(2));
		}

		try {
			new LogPreprocessor(base64).convertToXml(source, target);
		} catch (FileNotFoundException e) {
			Console.printerrln(e.getMessage());
		} catch (IOException e) {
			Console.printerrln(e.getMessage());
		}

	}

}
