
package de.ugoe.cs.quest.commands.sequences;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.SequenceInstanceOf;
import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.eventcore.gui.KeyInteractionCleaner;
import de.ugoe.cs.quest.eventcore.gui.KeyInteractionCleaner.CleanupMode;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @version $Revision: $ $Date: Sep 3, 2012$
 * @author 2012, last modified by $Author: sherbold$
 */
public class CMDcleanupKeyInteractions implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @SuppressWarnings("unchecked")
    @Override
    public void run(List<Object> parameters) {
        String sequencesName = null;
        String newSequencesName = null;
        String modeString = null;
        if (parameters.size() > 2) {
            sequencesName = (String) parameters.get(0);
            newSequencesName = (String) parameters.get(1);
            modeString = (String) parameters.get(2);
        }
        else {
            throw new InvalidParameterException();
        }

        Collection<List<Event>> sequences = null;
        Object dataObject = GlobalDataContainer.getInstance().getData(sequencesName);
        if (dataObject == null) {
            CommandHelpers.objectNotFoundMessage(sequencesName);
            return;
        }
        if (!SequenceInstanceOf.isCollectionOfSequences(dataObject)) {
            CommandHelpers.objectNotType(sequencesName, "Collection<List<Event>>");
            return;
        }
        sequences = (Collection<List<Event>>) dataObject;

        KeyInteractionCleaner.CleanupMode mode = null;
        try {
            mode = CleanupMode.valueOf(modeString);
        }
        catch (IllegalArgumentException e) {
            Console.printerrln("Invalid mode. Only REMOVAL and ADDITION are allowed values!");
            return;
        }

        Collection<List<Event>> newSequences = new LinkedList<List<Event>>();
        KeyInteractionCleaner cleaner = new KeyInteractionCleaner();

        int i=0;
        for (List<Event> sequence : sequences) {
            Console.traceln(Level.INFO, "Cleaning up sequence " + i++);
            newSequences.add(cleaner.cleanupKeyInteractions(sequence, mode));
        }

        if (GlobalDataContainer.getInstance().addData(newSequencesName, newSequences)) {
            CommandHelpers.dataOverwritten(newSequencesName);
        }

    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "cleanupKeyInteractions <sequencesName> <newSequencesName> <mode>";
    }

}
