/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.cluster.EdgeBetweennessClusterer;
import edu.uci.ics.jung.algorithms.layout.AggregateLayout;
import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.util.Relaxer;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.io.PajekNetReader;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;
import org.apache.commons.collections15.functors.MapTransformer;
import org.apache.commons.collections15.map.LazyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteringDemo
extends JApplet {
    VisualizationViewer<Number, Number> vv;
    Map<Number, Paint> vertexPaints = LazyMap.decorate(new HashMap(), new ConstantTransformer<Color>(Color.white));
    Map<Number, Paint> edgePaints = LazyMap.decorate(new HashMap(), new ConstantTransformer<Color>(Color.blue));
    public final Color[] similarColors = new Color[]{new Color(216, 134, 134), new Color(135, 137, 211), new Color(134, 206, 189), new Color(206, 176, 134), new Color(194, 204, 134), new Color(145, 214, 134), new Color(133, 178, 209), new Color(103, 148, 255), new Color(60, 220, 220), new Color(30, 250, 100)};

    public static void main(String[] args) throws IOException {
        ClusteringDemo cd = new ClusteringDemo();
        cd.start();
        JFrame jf = new JFrame();
        jf.getContentPane().add(cd);
        jf.setDefaultCloseOperation(3);
        jf.pack();
        jf.setVisible(true);
    }

    @Override
    public void start() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("datasets/zachary.net");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            this.setUpView(br);
        }
        catch (IOException e) {
            System.out.println("Error in loading graph");
            e.printStackTrace();
        }
    }

    private void setUpView(BufferedReader br) throws IOException {
        Factory<Number> vertexFactory = new Factory<Number>(){
            int n = 0;

            @Override
            public Number create() {
                return this.n++;
            }
        };
        Factory<Number> edgeFactory = new Factory<Number>(){
            int n = 0;

            @Override
            public Number create() {
                return this.n++;
            }
        };
        PajekNetReader pnr = new PajekNetReader((Factory)vertexFactory, (Factory)edgeFactory);
        SparseMultigraph graph = new SparseMultigraph();
        pnr.load((Reader)br, (Graph)graph);
        final AggregateLayout layout = new AggregateLayout((Layout)new FRLayout((Graph)graph));
        this.vv = new VisualizationViewer((Layout)layout);
        this.vv.setBackground(Color.white);
        this.vv.getRenderContext().setVertexFillPaintTransformer(MapTransformer.getInstance(this.vertexPaints));
        this.vv.getRenderContext().setVertexDrawPaintTransformer((Transformer)new Transformer<Number, Paint>(){

            @Override
            public Paint transform(Number v) {
                if (ClusteringDemo.this.vv.getPickedVertexState().isPicked((Object)v)) {
                    return Color.cyan;
                }
                return Color.BLACK;
            }
        });
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(MapTransformer.getInstance(this.edgePaints));
        this.vv.getRenderContext().setEdgeStrokeTransformer((Transformer)new Transformer<Number, Stroke>(){
            protected final Stroke THIN = new BasicStroke(1.0f);
            protected final Stroke THICK = new BasicStroke(2.0f);

            @Override
            public Stroke transform(Number e) {
                Paint c = ClusteringDemo.this.edgePaints.get(e);
                if (c == Color.LIGHT_GRAY) {
                    return this.THIN;
                }
                return this.THICK;
            }
        });
        JButton scramble = new JButton("Restart");
        scramble.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Layout layout = ClusteringDemo.this.vv.getGraphLayout();
                layout.initialize();
                Relaxer relaxer = ClusteringDemo.this.vv.getModel().getRelaxer();
                if (relaxer != null) {
                    relaxer.stop();
                    relaxer.prerelax();
                    relaxer.relax();
                }
            }
        });
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)gm);
        final JToggleButton groupVertices = new JToggleButton("Group Clusters");
        final JSlider edgeBetweennessSlider = new JSlider(0);
        edgeBetweennessSlider.setBackground(Color.WHITE);
        edgeBetweennessSlider.setPreferredSize(new Dimension(210, 50));
        edgeBetweennessSlider.setPaintTicks(true);
        edgeBetweennessSlider.setMaximum(graph.getEdgeCount());
        edgeBetweennessSlider.setMinimum(0);
        edgeBetweennessSlider.setValue(0);
        edgeBetweennessSlider.setMajorTickSpacing(10);
        edgeBetweennessSlider.setPaintLabels(true);
        edgeBetweennessSlider.setPaintTicks(true);
        final JPanel eastControls = new JPanel();
        eastControls.setOpaque(true);
        eastControls.setLayout(new BoxLayout(eastControls, 1));
        eastControls.add(Box.createVerticalGlue());
        eastControls.add(edgeBetweennessSlider);
        String COMMANDSTRING = "Edges removed for clusters: ";
        String eastSize = "Edges removed for clusters: " + edgeBetweennessSlider.getValue();
        final TitledBorder sliderBorder = BorderFactory.createTitledBorder(eastSize);
        eastControls.setBorder(sliderBorder);
        eastControls.add(Box.createVerticalGlue());
        groupVertices.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ClusteringDemo.this.clusterAndRecolor((AggregateLayout<Number, Number>)layout, edgeBetweennessSlider.getValue(), ClusteringDemo.this.similarColors, e.getStateChange() == 1);
                ClusteringDemo.this.vv.repaint();
            }
        });
        this.clusterAndRecolor((AggregateLayout<Number, Number>)layout, 0, this.similarColors, groupVertices.isSelected());
        edgeBetweennessSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    int numEdgesToRemove = source.getValue();
                    ClusteringDemo.this.clusterAndRecolor((AggregateLayout<Number, Number>)layout, numEdgesToRemove, ClusteringDemo.this.similarColors, groupVertices.isSelected());
                    sliderBorder.setTitle("Edges removed for clusters: " + edgeBetweennessSlider.getValue());
                    eastControls.repaint();
                    ClusteringDemo.this.vv.validate();
                    ClusteringDemo.this.vv.repaint();
                }
            }
        });
        Container content = this.getContentPane();
        content.add((Component)new GraphZoomScrollPane(this.vv));
        JPanel south = new JPanel();
        JPanel grid = new JPanel(new GridLayout(2, 1));
        grid.add(scramble);
        grid.add(groupVertices);
        south.add(grid);
        south.add(eastControls);
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        p.add(gm.getModeComboBox());
        south.add(p);
        content.add((Component)south, "South");
    }

    public void clusterAndRecolor(AggregateLayout<Number, Number> layout, int numEdgesToRemove, Color[] colors, boolean groupClusters) {
        Graph g = layout.getGraph();
        layout.removeAll();
        EdgeBetweennessClusterer clusterer = new EdgeBetweennessClusterer(numEdgesToRemove);
        Set clusterSet = clusterer.transform(g);
        List edges = clusterer.getEdgesRemoved();
        int i = 0;
        for (Set vertices : clusterSet) {
            Color c = colors[i % colors.length];
            this.colorCluster(vertices, c);
            if (groupClusters) {
                this.groupCluster(layout, vertices);
            }
            ++i;
        }
        for (Number e : g.getEdges()) {
            if (edges.contains(e)) {
                this.edgePaints.put(e, Color.lightGray);
                continue;
            }
            this.edgePaints.put(e, Color.black);
        }
    }

    private void colorCluster(Set<Number> vertices, Color c) {
        for (Number v : vertices) {
            this.vertexPaints.put(v, c);
        }
    }

    private void groupCluster(AggregateLayout<Number, Number> layout, Set<Number> vertices) {
        if (vertices.size() < layout.getGraph().getVertexCount()) {
            Point2D center = layout.transform((Object)vertices.iterator().next());
            Graph subGraph = (Graph)SparseMultigraph.getFactory().create();
            for (Number v : vertices) {
                subGraph.addVertex(v);
            }
            CircleLayout subLayout = new CircleLayout(subGraph);
            subLayout.setInitializer((Transformer)this.vv.getGraphLayout());
            subLayout.setSize(new Dimension(40, 40));
            layout.put((Layout)subLayout, center);
            this.vv.repaint();
        }
    }
}

