/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.SystemProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

public class InitializationChain
extends BytecodeScanningDetector {
    Set<String> requires = new TreeSet<String>();
    Map<String, Set<String>> classRequires = new TreeMap<String, Set<String>>();
    Set<String> staticFieldsAccessedInConstructor = new HashSet<String>();
    Map<String, BugInstance> staticFieldWritten = new HashMap<String, BugInstance>();
    private BugReporter bugReporter;
    private boolean instanceCreated;
    private int instanceCreatedPC;
    private boolean instanceCreatedWarningGiven;
    private static final boolean DEBUG = SystemProperties.getBoolean("ic.debug");

    public InitializationChain(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        this.instanceCreated = false;
        this.instanceCreatedWarningGiven = false;
        if (!this.getMethodName().equals("<clinit>") && !this.getMethodName().equals("<init>")) {
            return;
        }
        super.visit(obj);
        this.requires.remove(this.getDottedClassName());
        if (this.getDottedClassName().equals("java.lang.System")) {
            this.requires.add("java.io.FileInputStream");
            this.requires.add("java.io.FileOutputStream");
            this.requires.add("java.io.BufferedInputStream");
            this.requires.add("java.io.BufferedOutputStream");
            this.requires.add("java.io.PrintStream");
        }
        if (!this.requires.isEmpty()) {
            this.classRequires.put(this.getDottedClassName(), this.requires);
            this.requires = new TreeSet<String>();
        }
    }

    public void visitAfter(JavaClass obj) {
        for (String name : this.staticFieldsAccessedInConstructor) {
            BugInstance bug = this.staticFieldWritten.get(name);
            if (bug == null) continue;
            this.bugReporter.reportBug(bug);
        }
        this.staticFieldWritten.clear();
        this.staticFieldsAccessedInConstructor.clear();
    }

    public void sawOpcode(int seen) {
        if (this.getMethodName().equals("<init>")) {
            if (seen == 178 && this.getClassConstantOperand().equals(this.getClassName())) {
                this.staticFieldsAccessedInConstructor.add(this.getNameConstantOperand());
            }
            return;
        }
        if (seen == 179 && this.getClassConstantOperand().equals(this.getClassName())) {
            String okSig;
            if (this.instanceCreated && !this.instanceCreatedWarningGiven && !this.getSuperclassName().equals("java.lang.Enum") && !(okSig = "L" + this.getClassName() + ";").equals(this.getSigConstantOperand())) {
                this.staticFieldWritten.put(this.getNameConstantOperand(), new BugInstance(this, "SI_INSTANCE_BEFORE_FINALS_ASSIGNED", 2).addClassAndMethod(this).addReferencedField(this).addSourceLine(this, this.instanceCreatedPC));
                this.instanceCreatedWarningGiven = true;
            }
        } else if (seen == 187 && this.getClassConstantOperand().equals(this.getClassName())) {
            this.instanceCreated = true;
            this.instanceCreatedPC = this.getPC();
        } else if ((seen == 179 || seen == 178 || seen == 184 || seen == 187) && this.getPC() + 6 < this.codeBytes.length) {
            this.requires.add(this.getDottedClassConstantOperand());
        }
    }

    public void compute() {
        Set<String> allClasses = this.classRequires.keySet();
        TreeSet<String> emptyClasses = new TreeSet<String>();
        for (String c : allClasses) {
            Set<String> needs = this.classRequires.get(c);
            needs.retainAll(allClasses);
            TreeSet extra = new TreeSet();
            for (String need : needs) {
                extra.addAll(this.classRequires.get(need));
            }
            needs.addAll(extra);
            needs.retainAll(allClasses);
            this.classRequires.put(c, needs);
            if (!needs.isEmpty()) continue;
            emptyClasses.add(c);
        }
        for (String c : emptyClasses) {
            this.classRequires.remove(c);
        }
    }

    public void report() {
        if (DEBUG) {
            System.out.println("Finishing computation");
        }
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        this.compute();
        Set<String> allClasses = this.classRequires.keySet();
        for (String c : allClasses) {
            if (DEBUG) {
                System.out.println("Class " + c + " requires:");
            }
            for (String needs : this.classRequires.get(c)) {
                Set<String> s;
                if (DEBUG) {
                    System.out.println("  " + needs);
                }
                if ((s = this.classRequires.get(needs)) == null || !s.contains(c) || c.compareTo(needs) >= 0) continue;
                this.bugReporter.reportBug(new BugInstance(this, "IC_INIT_CIRCULARITY", 2).addClass(c).addClass(needs));
            }
        }
    }
}

