package de.ugoe.cs.quest.eventcore.gui;

import java.util.List;

import de.ugoe.cs.quest.eventcore.Event;

/**
 * <p>
 * A text input represents a list of key events that together represent entering text into a
 * text field or text area.
 * </p>
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public class TextInput implements IInteraction {
    
    public enum TextEquality {LEXICAL, SYNTACTICAL, SEMANTICAL};

    /**  */
    private static final long serialVersionUID = 1L;
    
    /** the text resulting from the text input events */
    private String enteredText;

    /** the text input events that caused the entering of the text */
    private List<Event> textInputEvents;
    
    private final TextEquality equalityType;

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param enteredText
     * @param textInputEvents
     */
    public TextInput(String enteredText, List<Event> textInputEvents) {
        this(enteredText, textInputEvents, TextEquality.LEXICAL);
    }
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param enteredText
     * @param textInputEvents
     * @param equalityType
     */
    public TextInput(String enteredText, List<Event> textInputEvents, TextEquality equalityType) {
        this.enteredText = enteredText;
        this.textInputEvents = textInputEvents;
        this.equalityType = equalityType;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#getName()
     */
    public String getName() {
        return "TextInput(\"" + enteredText + "\")";
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "text input \"" + enteredText + "\"";
    }

    /**
     * @return the enteredText
     */
    public String getEnteredText() {
        return enteredText;
    }

    /**
     * @return the textInputEvents
     */
    public List<Event> getTextInputEvents() {
        return textInputEvents;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#startsLogicalSequence()
     */
    public boolean startsLogicalSequence() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#finishesLogicalSequence()
     */
    public boolean finishesLogicalSequence() {
        return false;
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        else if (obj instanceof TextInput) {
            switch (equalityType)
            {
                case LEXICAL:
                    return textInputEvents.equals(((TextInput) obj).textInputEvents);
                case SYNTACTICAL:
                    return enteredText.equals(((TextInput) obj).enteredText);
                case SEMANTICAL:
                    return true;
                default:
                    throw new AssertionError("reached source code that should be unreachable");
            }
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        int hashCode = getClass().hashCode();
        if( equalityType==TextEquality.LEXICAL) {
            hashCode += enteredText.hashCode() + textInputEvents.size();
        }
        else if( equalityType==TextEquality.SYNTACTICAL) {
            hashCode += enteredText.hashCode();
        }
        return hashCode;
    }

}
