package de.ugoe.cs.quest.plugin.guitar.commands;

import java.util.List;

import de.ugoe.cs.quest.plugin.guitar.EFGModelGenerator;
import de.ugoe.cs.quest.usageprofiles.FirstOrderMarkovModel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to that loads an EFG and creates a first-order Markov model with the
 * same structure.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDefgToMM implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String filename;
		String modelname;
		try {
			filename = (String) parameters.get(0);
			modelname = (String) parameters.get(1);
		} catch (Exception e) {
			throw new IllegalArgumentException();
		}

		EFGModelGenerator modelGenerator = new EFGModelGenerator();
		FirstOrderMarkovModel model = modelGenerator
				.efgToFirstOrderMarkovModel(filename);
		GlobalDataContainer.getInstance().addData(modelname, model);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "efgToMM <filename> <modelname>";
	}

}
