package de.ugoe.cs.quest.assertions;

import org.junit.*;

import de.ugoe.cs.quest.assertions.FileEqualsReplay;
import static org.junit.Assert.*;

/**
 * The class <code>FileEqualsReplayTest</code> contains tests for the class
 * <code>{@link FileEqualsReplay}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class FileEqualsReplayTest {

	private final static String ENDLINE = System.getProperty("line.separator");

	@Test
	public void testFileEqualsReplay_1() throws Exception {
		String expectedFile = "expectedFileString";
		String actualFile = "actualFileString";

		FileEqualsReplay result = new FileEqualsReplay(expectedFile, actualFile);

		assertNotNull(result);
		assertEquals(expectedFile, result.expectedFile);
		assertEquals(actualFile, result.actualFile);
	}

	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testFileEqualsReplay_2() throws Exception {
		String actualFile = "actualFileString";

		new FileEqualsReplay(null, actualFile);
	}

	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testFileEqualsReplay_3() throws Exception {
		String expectedFile = "expectedFileString";

		new FileEqualsReplay(expectedFile, null);
	}

	@Test
	public void testGetReplay_1() throws Exception {
		FileEqualsReplay fixture = new FileEqualsReplay("", "");

		String result = fixture.getReplay();

		assertEquals("  <fileEquals actualFile=\"\" expectedFile=\"\"/>"
				+ ENDLINE, result);
	}

	@Test
	public void testGetReplay_2() throws Exception {

		FileEqualsReplay fixture = new FileEqualsReplay("expectedFileString",
				"actualFileString");

		String result = fixture.getReplay();

		assertEquals(
				"  <fileEquals actualFile=\"actualFileString\" expectedFile=\"expectedFileString\"/>"
						+ ENDLINE, result);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(FileEqualsReplayTest.class);
	}
}