package de.ugoe.cs.quest.eventcore;


import java.util.LinkedList;
import java.util.List;

import org.junit.*;

import de.ugoe.cs.quest.eventcore.Event;

import static org.junit.Assert.*;
import static org.mockito.Mockito.*;

/**
 * The class <code>EventTest</code> contains tests for the class <code>{@link Event}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class EventTest {

    @Test
    public void testEvent_1() throws Exception {
        Event result = new Event(mock(IEventType.class));

        assertNotNull(result);
    }

    @Test(expected = java.lang.IllegalArgumentException.class)
    public void testEvent_2() throws Exception {
        new Event(null);
    }

    /*
    @Test
    public void testEquals_1() throws Exception {
        IEventType type1 = mock(IEventType.class);
        IEventType type2 = mock(IEventType.class);
        // when(type1.equals(type2)).thenReturn(true);
        Event fixture = new Event(type1);
        Event other = new Event(type2);

        boolean result = fixture.equals(other);

        assertTrue(result);
    }

    @Test
    public void testEquals_2() throws Exception {
        String type1 = "typeString1";
        String type2 = "typeString2";
        Event fixture = new Event(type1);
        Event other = new Event(type2);

        boolean result = fixture.equals(other);

        assertFalse(result);
    }

    @Test
    public void testEquals_3() throws Exception {
        String type1 = "typeString";
        String type2 = "typeString";
        String target1 = "target";
        String target2 = "target";
        Event fixture = new Event(type1);
        fixture.target = target1;
        Event other = new Event(type2);
        other.target = target2;

        boolean result = fixture.equals(other);

        assertTrue(result);
    }

    @Test
    public void testEquals_4() throws Exception {
        String type1 = "typeString1";
        String type2 = "typeString2";
        String target1 = "target";
        String target2 = "target";
        Event fixture = new Event(type1);
        fixture.target = target1;
        Event other = new Event(type2);
        other.target = target2;

        boolean result = fixture.equals(other);

        assertFalse(result);
    }

    @Test
    public void testEquals_5() throws Exception {
        String type1 = "typeString";
        String type2 = "typeString";
        String target1 = "target1";
        String target2 = "target2";
        Event fixture = new Event(type1);
        fixture.target = target1;
        Event other = new Event(type2);
        other.target = target2;

        boolean result = fixture.equals(other);

        assertFalse(result);
    }

    @Test
    public void testEquals_6() throws Exception {
        String type = "typeString";
        Event fixture = new Event(type);

        boolean result = fixture.equals(fixture);

        assertTrue(result);
    }

    @Test
    public void testEqualsContract() throws Exception {
        EqualsVerifier.forClass(Event.class).suppress(Warning.NONFINAL_FIELDS)
            .withRedefinedSubclass(ReplayableEvent.class).verify();
    }
    */

    @Test
    public void testGetTarget_1() throws Exception {
        IEventType type = mock(IEventType.class);
        IEventTarget target = mock(IEventTarget.class);
        
        Event fixture = new Event(type);
        fixture.setTarget(target);

        IEventTarget result = fixture.getTarget();

        assertSame(target, result);
    }
    
    

    @Test
    public void testGetTarget_2() throws Exception {
        IEventType type = mock(IEventType.class);
        IEventTarget target = mock(IEventTarget.class);
        
        Event fixture = new Event(type, target);

        IEventTarget result = fixture.getTarget();

        assertSame(target, result);
    }
    
    @Test
    public void testGetTarget_3() throws Exception {
        IEventType type = mock(IEventType.class);
        
        Event fixture = new Event(type);

        IEventTarget result = fixture.getTarget();

        assertNull(result);
    }

    @Test
    public void testGetType_1() throws Exception {
        IEventType type = mock(IEventType.class);
        
        Event fixture = new Event(type);

        IEventType result = fixture.getType();

        assertEquals(type, result);
    }

    @Test
    public void testSetTarget_1() throws Exception {
        IEventType type = mock(IEventType.class);
        IEventTarget target = mock(IEventTarget.class);
        
        Event fixture = new Event(type);

        boolean result = fixture.setTarget(target);

        assertTrue(result);
        assertEquals(target, fixture.getTarget());
    }

    @Test
    public void testSetTarget_2() throws Exception {
        IEventType type = mock(IEventType.class);
        IEventTarget target1 = mock(IEventTarget.class);
        IEventTarget target2 = mock(IEventTarget.class);
        
        Event fixture = new Event(type);

        fixture.setTarget(target1);
        boolean result = fixture.setTarget(target2);
        
        assertFalse(result);
        assertEquals(target1, fixture.target);
    }
    
    @Test
    public void testSetTarget_3() throws Exception {
        IEventType type = mock(IEventType.class);
        IEventTarget target1 = mock(IEventTarget.class);
        IEventTarget target2 = mock(IEventTarget.class);
        
        Event fixture = new Event(type, target1);

        boolean result = fixture.setTarget(target2);
        
        assertFalse(result);
        assertEquals(target1, fixture.target);
    }

    @Test
    public void testToString_1() throws Exception {
        IEventType type = mock(IEventType.class);
        when(type.toString()).thenReturn("typeString");
        IEventTarget target = mock(IEventTarget.class);
        when(target.toString()).thenReturn("targetString");
        
        Event fixture = new Event(type, target);

        String result = fixture.toString();

        assertEquals("typeString.targetString", result);
    }
    
    @Test
    public void testToString_2() throws Exception {
        IEventType type = mock(IEventType.class);
        when(type.toString()).thenReturn("typeString");
        
        Event fixture = new Event(type);
        
        String result = fixture.toString();
        
        assertEquals("typeString", result);
    }
    
    @Test
    public void testAddReplayable_1() throws Exception {
        IReplayable replayable = mock(IReplayable.class);

        Event fixture = new Event(mock(IEventType.class));
        fixture.addReplayable(replayable);

        assertEquals(1, fixture.getReplayables().size());
        assertEquals(replayable, fixture.getReplayables().get(0));
    }

    @Test
    public void testAddReplayEvent_2() throws Exception {
        IReplayable replayable1 = mock(IReplayable.class);
        IReplayable replayable2 = mock(IReplayable.class);

        Event fixture = new Event(mock(IEventType.class));
        fixture.addReplayable(replayable1);
        fixture.addReplayable(replayable2);

        assertEquals(2, fixture.getReplayables().size());
        assertEquals(replayable1, fixture.getReplayables().get(0));
        assertEquals(replayable2, fixture.getReplayables().get(1));
    }

    @Test(expected = java.lang.IllegalArgumentException.class)
    public void testAddReplayEvent_fixture_3() throws Exception {
        Event fixture = new Event(mock(IEventType.class));
        fixture.addReplayable(null);
    }

    @Test
    public void testAddReplaySequence_1() throws Exception {
        IReplayable replayable1 = mock(IReplayable.class);
        IReplayable replayable2 = mock(IReplayable.class);

        List<IReplayable> replayableSequences = new LinkedList<IReplayable>();
        replayableSequences.add(replayable1);
        replayableSequences.add(replayable2);

        Event fixture = new Event(mock(IEventType.class));

        fixture.addReplayableSequence(replayableSequences);

        assertEquals(2, fixture.getReplayables().size());
        assertEquals(replayable1, fixture.getReplayables().get(0));
        assertEquals(replayable2, fixture.getReplayables().get(1));
    }

    @Test(expected = java.lang.IllegalArgumentException.class)
    public void testAddReplaySequence_2() throws Exception {
        Event fixture = new Event(mock(IEventType.class));

        fixture.addReplayableSequence(null);
    }

    public static void main(String[] args) {
        new org.junit.runner.JUnitCore().run(EventTest.class);
    }
}
