/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.ch;

import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.ch.InheritanceEdge;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.graph.AbstractVertex;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassVertex
extends AbstractVertex<InheritanceEdge, ClassVertex> {
    private static final int FINISHED = 1;
    private static final int APPLICATION_CLASS = 2;
    private static final int INTERFACE = 4;
    private final ClassDescriptor classDescriptor;
    @CheckForNull
    private final XClass xclass;
    private int flags;
    private ClassVertex directSuperclass;

    public String toString() {
        return this.classDescriptor.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ClassVertex)) {
            return false;
        }
        return this.classDescriptor.equals(((ClassVertex)o).classDescriptor);
    }

    @Override
    public int hashCode() {
        return this.classDescriptor.hashCode();
    }

    private ClassVertex(ClassDescriptor classDescriptor, XClass xclass) {
        this.classDescriptor = classDescriptor;
        this.xclass = xclass;
        this.flags = 0;
        if (xclass.isInterface()) {
            this.setInterface();
        }
    }

    private ClassVertex(ClassDescriptor classDescriptor, boolean isInterfaceEdge) {
        this.classDescriptor = classDescriptor;
        this.xclass = null;
        this.flags = 0;
        if (isInterfaceEdge) {
            this.setInterface();
        }
    }

    public static ClassVertex createResolvedClassVertex(ClassDescriptor classDescriptor, XClass xclass) {
        return new ClassVertex(classDescriptor, xclass);
    }

    public static ClassVertex createMissingClassVertex(ClassDescriptor classDescriptor, boolean isInterface) {
        return new ClassVertex(classDescriptor, isInterface);
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    @Nullable
    public XClass getXClass() {
        return this.xclass;
    }

    public boolean isResolved() {
        return this.xclass != null;
    }

    public void setFinished(boolean finished) {
        this.setFlag(1, finished);
    }

    public boolean isFinished() {
        return this.isFlagSet(1);
    }

    public void markAsApplicationClass() {
        this.setFlag(2, true);
    }

    public boolean isApplicationClass() {
        return this.isFlagSet(2);
    }

    private void setInterface() {
        this.setFlag(4, true);
    }

    public boolean isInterface() {
        return this.isFlagSet(4);
    }

    public void setDirectSuperclass(ClassVertex target) {
        this.directSuperclass = target;
    }

    public ClassVertex getDirectSuperclass() {
        return this.directSuperclass;
    }

    private void setFlag(int flag, boolean enable) {
        this.flags = enable ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    private boolean isFlagSet(int flag) {
        return (this.flags & flag) != 0;
    }
}

