package de.ugoe.cs.util.console;

import java.util.ArrayList;
import java.util.List;
import org.junit.*;
import static org.junit.Assert.*;

/**
 * The class <code>CommandParserTest</code> contains tests for the class
 * <code>{@link CommandParser}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CommandParserTest {

	@Test
	public void testCommandParser_1() throws Exception {

		CommandParser result = new CommandParser();

		// add additional test code here
		assertNotNull(result);
		assertEquals("", result.getCommandName());
		assertTrue(result.getParameters().isEmpty());
	}

	@Test
	public void testGetParameters_1() throws Exception {
		CommandParser fixture = new CommandParser();

		List<Object> result = fixture.getParameters();

		// add additional test code here
		assertNotNull(result);
		assertEquals(0, result.size());
	}

	@Test
	public void testParse_1() throws Exception {
		CommandParser commandParser = new CommandParser();
		String command = "test";
		commandParser.parse(command);

		assertEquals("test", commandParser.getCommandName());
		assertTrue(commandParser.getParameters().isEmpty());
	}

	@Test
	public void testParse_2() throws Exception {
		CommandParser commandParser = new CommandParser();
		String command = "test param1";
		List<Object> expectedParameters = new ArrayList<Object>();
		expectedParameters.add("param1");

		commandParser.parse(command);

		assertEquals("test", commandParser.getCommandName());
		assertArrayEquals(expectedParameters.toArray(), commandParser
				.getParameters().toArray());
	}

	@Test
	public void testParse_3() throws Exception {
		CommandParser commandParser = new CommandParser();
		String command = "test param1 param2";
		List<Object> expectedParameters = new ArrayList<Object>();
		expectedParameters.add("param1");
		expectedParameters.add("param2");

		commandParser.parse(command);

		assertEquals("test", commandParser.getCommandName());
		assertArrayEquals(expectedParameters.toArray(), commandParser
				.getParameters().toArray());
	}

	@Test
	public void testParse_4() throws Exception {
		CommandParser commandParser = new CommandParser();
		String command = "test [array1]";
		List<Object> expectedParameters = new ArrayList<Object>();
		expectedParameters.add(new String[] { "array1" });

		commandParser.parse(command);

		assertEquals("test", commandParser.getCommandName());
		assertArrayEquals(expectedParameters.toArray(), commandParser
				.getParameters().toArray());
	}

	@Test
	public void testParse_5() throws Exception {
		CommandParser commandParser = new CommandParser();
		String command = "test [array1 array2]";
		List<Object> expectedParameters = new ArrayList<Object>();
		expectedParameters.add(new String[] { "array1", "array2" });

		commandParser.parse(command);

		assertEquals("test", commandParser.getCommandName());
		assertArrayEquals(expectedParameters.toArray(), commandParser
				.getParameters().toArray());
	}

	@Test
	public void testParse_6() throws Exception {
		CommandParser commandParser = new CommandParser();
		String command = "test [array1] param1";
		List<Object> expectedParameters = new ArrayList<Object>();
		expectedParameters.add(new String[] { "array1" });
		expectedParameters.add("param1");

		commandParser.parse(command);

		assertEquals("test", commandParser.getCommandName());
		assertArrayEquals(expectedParameters.toArray(), commandParser
				.getParameters().toArray());
	}

	@Test
	public void testParse_7() throws Exception {
		CommandParser commandParser = new CommandParser();
		String command = "test 'param 1'";
		List<Object> expectedParameters = new ArrayList<Object>();
		expectedParameters.add("param 1");

		commandParser.parse(command);

		assertEquals("test", commandParser.getCommandName());
		assertArrayEquals(expectedParameters.toArray(), commandParser
				.getParameters().toArray());
	}

	@Test
	public void testParse_8() throws Exception {
		CommandParser commandParser = new CommandParser();
		String command = "test ['array 1']";
		List<Object> expectedParameters = new ArrayList<Object>();
		expectedParameters.add(new String[] { "array 1" });

		commandParser.parse(command);

		assertEquals("test", commandParser.getCommandName());
		assertArrayEquals(expectedParameters.toArray(), commandParser
				.getParameters().toArray());
	}

	@Test
	public void testParse_9() throws Exception {
		CommandParser commandParser = new CommandParser();
		String command = "test ['array 1' array2]";
		List<Object> expectedParameters = new ArrayList<Object>();
		expectedParameters.add(new String[] { "array 1", "array2" });

		commandParser.parse(command);

		assertEquals("test", commandParser.getCommandName());
		assertArrayEquals(expectedParameters.toArray(), commandParser
				.getParameters().toArray());
	}

	@Test
	public void testParse_10() throws Exception {
		CommandParser commandParser = new CommandParser();
		String command = "test [array1  array2]";
		List<Object> expectedParameters = new ArrayList<Object>();
		expectedParameters.add(new String[] { "array1", "array2" });

		commandParser.parse(command);

		assertEquals("test", commandParser.getCommandName());
		assertArrayEquals(expectedParameters.toArray(), commandParser
				.getParameters().toArray());
	}

	@Test
	public void testParse_11() throws Exception {
		CommandParser commandParser = new CommandParser();
		String command = "test 'param 1";
		List<Object> expectedParameters = new ArrayList<Object>();
		expectedParameters.add("param 1");

		commandParser.parse(command);

		assertEquals("test", commandParser.getCommandName());
		assertArrayEquals(expectedParameters.toArray(), commandParser
				.getParameters().toArray());
	}

	@Test
	public void testParse_12() throws Exception {
		CommandParser commandParser = new CommandParser();
		String command = "test 'param1 [array1]";
		List<Object> expectedParameters = new ArrayList<Object>();
		expectedParameters.add("param1 [array1]");

		commandParser.parse(command);

		assertEquals("test", commandParser.getCommandName());
		assertArrayEquals(expectedParameters.toArray(), commandParser
				.getParameters().toArray());
	}

	@Test
	public void testParse_13() throws Exception {
		CommandParser commandParser = new CommandParser();
		String command = "test param1' [array1]";
		List<Object> expectedParameters = new ArrayList<Object>();
		expectedParameters.add("param1'");
		expectedParameters.add(new String[] { "array1" });

		commandParser.parse(command);

		assertEquals("test", commandParser.getCommandName());
		assertArrayEquals(expectedParameters.toArray(), commandParser
				.getParameters().toArray());
	}

	@Test
	public void testParse_14() throws Exception {
		CommandParser commandParser = new CommandParser();
		String command = "";
		commandParser.parse(command);
		assertEquals("", commandParser.getCommandName());
		assertTrue(commandParser.getParameters().isEmpty());
	}

	@Test
	public void testParse_15() throws Exception {
		CommandParser commandParser = new CommandParser();
		String command = null;
		commandParser.parse(command);
		assertEquals("", commandParser.getCommandName());
		assertTrue(commandParser.getParameters().isEmpty());
	}

	@Test
	public void testParse_16() throws Exception {
		CommandParser commandParser = new CommandParser();
		String command = "test param1  param2";
		List<Object> expectedParameters = new ArrayList<Object>();
		expectedParameters.add("param1");
		expectedParameters.add("param2");

		commandParser.parse(command);
		assertEquals("test", commandParser.getCommandName());
		assertArrayEquals(expectedParameters.toArray(), commandParser
				.getParameters().toArray());
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(CommandParserTest.class);
	}
}