
package de.ugoe.cs.quest.eventcore.gui;

import de.ugoe.cs.tasktree.keyboardmaps.VirtualKey;

public class KeyTyped extends KeyInteraction {

    /**  */
    private static final long serialVersionUID = 1L;

    /**
     * @param key
     */
    public KeyTyped(VirtualKey key) {
        super(key);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#getName()
     */
    public String getName() {
        return "KeyTyped " + super.getKey();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "typed key " + super.getKey();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#startsLogicalSequence()
     */
    public boolean startsLogicalSequence() {
        // TODO handle lock keys correctly
        return super.getKey().isCombinationKey();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#finishesLogicalSequence()
     */
    public boolean finishesLogicalSequence() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object other) {
        if (other instanceof KeyTyped) {
            return (super.getKey() == ((KeyTyped) other).getKey());
        }
        else {
            return false;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return super.getKey().hashCode();
    }

}
