
package de.ugoe.cs.quest.eventcore;

import java.io.Serializable;

/**
 * <p>
 * Common interface for event types. An event type can be, e.g., a mouse click, a keyboard
 * interactions in case of GUI platforms or a HTTP request in case of a Web application.
 * </p>
 * 
 * @version 1.0
 * @author Steffen Herbold
 */
public interface IEventType extends Serializable {

    /**
     * <p>
     * Returns the name of the event type.
     * </p>
     * 
     * @return name of the event type
     */
    public String getName();

}
