
package de.ugoe.cs.util.console.defaultcommands;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.util.console.CommandExecuter;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.defaultcommands.CMDlistCommands;
import de.ugoe.cs.util.console.listener.IOutputListener;

public class CMDlistCommandsTest implements IOutputListener {

    private List<String> commands = new ArrayList<String>();

    @Before
    public void setUp() throws Exception {
        Console.getInstance().registerOutputListener(this);
    }

    @Test
    public void test() {
        CommandExecuter.getInstance().addCommandPackage("de.ugoe.cs.util.console.defaultcommands");
        CMDlistCommands command = new CMDlistCommands();
        command.run(null);

        assertTrue(commands.size() > 0);

        for (String cmd : commands) {
            assertNotNull(cmd);
            assertTrue(cmd.length() > 0);
            System.out.print(cmd);
        }
    }

    @Override
    public void outputMsg(String newMessage) {
        commands.add(newMessage);
    }

}
