package de.ugoe.cs.quest.eventcore.gui;

import de.ugoe.cs.tasktree.keyboardmaps.VirtualKey;

/**
 * <p>
 * Event type for releasing a key.
 * </p>
 * 
 * @version 1.0
 * @author Steffen Herbold
 */
public class KeyReleased extends KeyInteraction {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new {@link KeyReleased} event type.
     * </p>
     * 
     * @see KeyInteraction#KeyInteraction(VirtualKey)
     */
    public KeyReleased(VirtualKey key) {
        super(key);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#getName()
     */
    public String getName() {
        return "KeyReleased " + super.getKey();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "releasing key " + super.getKey();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#startsLogicalSequence()
     */
    public boolean startsLogicalSequence() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#finishesLogicalSequence()
     */
    public boolean finishesLogicalSequence() {
        // TODO handle lock keys correctly
        return super.getKey().isCombinationKey();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object other) {
        if (other instanceof KeyReleased) {
            return (super.getKey() == ((KeyReleased) other).getKey());
        }
        else {
            return false;
        }
    }

    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return super.getKey().hashCode();
    }

}
