/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.TestGraphs;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.SatelliteVisualizationViewer;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.renderers.GradientVertexRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.GeneralPath;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SatelliteViewDemo<V, E>
extends JApplet {
    static final String instructions = "<html><b><h2><center>Instructions for Mouse Listeners</center></h2></b><p>There are two modes, Transforming and Picking.<p>The modes are selected with a combo box.<p><p><b>Transforming Mode:</b><ul><li>Mouse1+drag pans the graph<li>Mouse1+Shift+drag rotates the graph<li>Mouse1+CTRL(or Command)+drag shears the graph</ul><b>Picking Mode:</b><ul><li>Mouse1 on a Vertex selects the vertex<li>Mouse1 elsewhere unselects all Vertices<li>Mouse1+Shift on a Vertex adds/removes Vertex selection<li>Mouse1+drag on a Vertex moves all selected Vertices<li>Mouse1+drag elsewhere selects Vertices in a region<li>Mouse1+Shift+drag adds selection of Vertices in a new region<li>Mouse1+CTRL on a Vertex selects the vertex and centers the display on it</ul><b>Both Modes:</b><ul><li>Mousewheel scales with a crossover value of 1.0.<p>     - scales the graph layout when the combined scale is greater than 1<p>     - scales the graph view when the combined scale is less than 1";
    JDialog helpDialog;
    VisualizationServer.Paintable viewGrid;

    public SatelliteViewDemo() {
        Graph graph = TestGraphs.getOneComponentGraph();
        Dimension preferredSize1 = new Dimension(600, 600);
        Dimension preferredSize2 = new Dimension(300, 300);
        FRLayout layout = new FRLayout(graph);
        layout.setMaxIterations(500);
        DefaultVisualizationModel vm = new DefaultVisualizationModel((Layout)layout, preferredSize1);
        VisualizationViewer vv1 = new VisualizationViewer((VisualizationModel)vm, preferredSize1);
        final SatelliteVisualizationViewer vv2 = new SatelliteVisualizationViewer(vv1, preferredSize2);
        vv1.setBackground(Color.white);
        vv1.getRenderContext().setEdgeDrawPaintTransformer((Transformer)new PickableEdgePaintTransformer((PickedInfo)vv1.getPickedEdgeState(), (Paint)Color.black, (Paint)Color.cyan));
        vv1.getRenderContext().setVertexFillPaintTransformer((Transformer)new PickableVertexPaintTransformer((PickedInfo)vv1.getPickedVertexState(), (Paint)Color.red, (Paint)Color.yellow));
        vv2.getRenderContext().setEdgeDrawPaintTransformer((Transformer)new PickableEdgePaintTransformer((PickedInfo)vv2.getPickedEdgeState(), (Paint)Color.black, (Paint)Color.cyan));
        vv2.getRenderContext().setVertexFillPaintTransformer((Transformer)new PickableVertexPaintTransformer((PickedInfo)vv2.getPickedVertexState(), (Paint)Color.red, (Paint)Color.yellow));
        vv1.getRenderer().setVertexRenderer((Renderer.Vertex)new GradientVertexRenderer(Color.red, Color.white, true));
        vv1.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        vv1.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        CrossoverScalingControl vv2Scaler = new CrossoverScalingControl();
        vv2.scaleToLayout((ScalingControl)vv2Scaler);
        this.viewGrid = new ViewGrid((VisualizationViewer)vv2, vv1);
        vv1.setVertexToolTipTransformer((Transformer)new ToStringLabeller());
        vv2.setVertexToolTipTransformer((Transformer)new ToStringLabeller());
        vv2.getRenderContext().setVertexLabelTransformer(vv1.getRenderContext().getVertexLabelTransformer());
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        Container content = this.getContentPane();
        JPanel panel = new JPanel(new BorderLayout());
        JPanel rightPanel = new JPanel(new GridLayout(2, 1));
        GraphZoomScrollPane gzsp = new GraphZoomScrollPane(vv1);
        panel.add((Component)gzsp);
        rightPanel.add(new JPanel());
        rightPanel.add((Component)vv2);
        panel.add((Component)rightPanel, "East");
        this.helpDialog = new JDialog();
        this.helpDialog.getContentPane().add(new JLabel(instructions));
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        vv1.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler, vv1){
            final /* synthetic */ ScalingControl val$scaler;
            final /* synthetic */ VisualizationViewer val$vv1;
            {
                this.val$scaler = scalingControl;
                this.val$vv1 = visualizationViewer;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale((VisualizationServer)this.val$vv1, 1.1f, this.val$vv1.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler, vv1){
            final /* synthetic */ ScalingControl val$scaler;
            final /* synthetic */ VisualizationViewer val$vv1;
            {
                this.val$scaler = scalingControl;
                this.val$vv1 = visualizationViewer;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale((VisualizationServer)this.val$vv1, 0.9090909f, this.val$vv1.getCenter());
            }
        });
        JComboBox modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(((DefaultModalGraphMouse)vv2.getGraphMouse()).getModeListener());
        JCheckBox gridBox = new JCheckBox("Show Grid");
        gridBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SatelliteViewDemo.this.showGrid((VisualizationViewer)vv2, e.getStateChange() == 1);
            }
        });
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SatelliteViewDemo.this.helpDialog.pack();
                SatelliteViewDemo.this.helpDialog.setVisible(true);
            }
        });
        JPanel controls = new JPanel();
        controls.add(plus);
        controls.add(minus);
        controls.add(modeBox);
        controls.add(gridBox);
        controls.add(help);
        content.add(panel);
        content.add((Component)controls, "South");
    }

    protected void showGrid(VisualizationViewer vv, boolean state) {
        if (state) {
            vv.addPreRenderPaintable(this.viewGrid);
        } else {
            vv.removePreRenderPaintable(this.viewGrid);
        }
        vv.repaint();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new SatelliteViewDemo());
        f.pack();
        f.setVisible(true);
    }

    static class ViewGrid
    implements VisualizationServer.Paintable {
        VisualizationViewer master;
        VisualizationViewer vv;

        public ViewGrid(VisualizationViewer vv, VisualizationViewer master) {
            this.vv = vv;
            this.master = master;
        }

        public void paint(Graphics g) {
            int i;
            MutableTransformer masterViewTransformer = this.master.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW);
            MutableTransformer masterLayoutTransformer = this.master.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
            MutableTransformer vvLayoutTransformer = this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
            Rectangle rect = this.master.getBounds();
            GeneralPath path = new GeneralPath();
            path.moveTo(rect.x, rect.y);
            path.lineTo(rect.width, rect.y);
            path.lineTo(rect.width, rect.height);
            path.lineTo(rect.x, rect.height);
            path.lineTo(rect.x, rect.y);
            for (i = 0; i <= rect.width; i += rect.width / 10) {
                path.moveTo(rect.x + i, rect.y);
                path.lineTo(rect.x + i, rect.height);
            }
            for (i = 0; i <= rect.height; i += rect.height / 10) {
                path.moveTo(rect.x, rect.y + i);
                path.lineTo(rect.width, rect.y + i);
            }
            Shape lens = path;
            lens = masterViewTransformer.inverseTransform(lens);
            lens = masterLayoutTransformer.inverseTransform(lens);
            lens = vvLayoutTransformer.transform(lens);
            Graphics2D g2d = (Graphics2D)g;
            Color old = g.getColor();
            g.setColor(Color.cyan);
            g2d.draw(lens);
            path = new GeneralPath();
            path.moveTo((float)rect.getMinX(), (float)rect.getCenterY());
            path.lineTo((float)rect.getMaxX(), (float)rect.getCenterY());
            path.moveTo((float)rect.getCenterX(), (float)rect.getMinY());
            path.lineTo((float)rect.getCenterX(), (float)rect.getMaxY());
            Shape crosshairShape = path;
            crosshairShape = masterViewTransformer.inverseTransform(crosshairShape);
            crosshairShape = masterLayoutTransformer.inverseTransform(crosshairShape);
            crosshairShape = vvLayoutTransformer.transform(crosshairShape);
            g.setColor(Color.black);
            g2d.setStroke(new BasicStroke(3.0f));
            g2d.draw(crosshairShape);
            g.setColor(old);
        }

        public boolean useTransform() {
            return true;
        }
    }
}

