
package de.ugoe.cs.quest.eventcore.gui;

/**
 * <p>
 * Event type for keyboard focus changes. The target of the respective event has obtained the
 * keyboard focus of the application.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class KeyboardFocusChange implements IInteraction {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#getName()
     */
    public String getName() {
        return "KeyboardFocusChange";
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.userinteraction.Interaction#startsLogicalSequence()
     */
    @Override
    public boolean startsLogicalSequence() {
        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.userinteraction.Interaction#finishesLogicalSequence()
     */
    @Override
    public boolean finishesLogicalSequence() {
        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "keyboard focus changed";
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KeyboardFocusChange) {
            return true;
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return getClass().hashCode();
    }
}
