package de.ugoe.cs.util.console.listener;

import de.ugoe.cs.util.console.CommandExecuter;

/**
 * <p>
 * Interface for listeners observing the commands executed by the
 * {@link CommandExecuter}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public interface ICommandListener {
	/**
	 * <p>
	 * Receives the command strings of all executed by the
	 * {@link CommandExecuter}.
	 * </p>
	 * 
	 * @param command
	 *            string of the command.
	 */
	public void commandNotification(String command);
}
