package de.ugoe.cs.quest.tasktrees.treeimpl;

import java.util.ArrayList;
import java.util.List;

import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNodeInfo;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNode;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public class NodeInfo implements ITaskTreeNodeInfo {
    
    /** */
    private ITaskTreeNode task;

    /** */
    private long lastUpdate;

    /** */
    private List<ITaskTreeNode> parentNodes = new ArrayList<ITaskTreeNode>();

    /**
     * @param node
     */
    NodeInfo(ITaskTreeNode task) {
        this.task = task;
        lastUpdate = System.currentTimeMillis();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.NodeInfo#getTask()
     */
    @Override
    public ITaskTreeNode getTask() {
        return task;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeimpl.NodeInfo#getNoOfOccurencesInTree()
     */
    @Override
    public int getNoOfOccurencesInTree() {
        return parentNodes.size();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeimpl.NodeInfo#getLastUpdate()
     */
    @Override
    public long getLastUpdate() {
        return lastUpdate;
    }

    /**
     * TODO: comment
     * 
     */
    void addParent(ITaskTreeNode parent) {
        parentNodes.add(parent);
    }

    /**
     * TODO: comment
     * 
     */
    void removeParent(ITaskTreeNode parent) {
        parentNodes.remove(parent);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public synchronized String toString() {
        return "NodeInfo(" + task + ", " + parentNodes.size() + " parents)";
    }

}
