package de.ugoe.cs.quest.plugin.mfc.eventcore;

import java.util.Map;

import de.ugoe.cs.quest.eventcore.IEventType;
import de.ugoe.cs.quest.eventcore.gui.KeyPressed;
import de.ugoe.cs.quest.eventcore.gui.KeyReleased;
import de.ugoe.cs.quest.eventcore.gui.KeyboardFocusChange;
import de.ugoe.cs.quest.eventcore.gui.MouseButtonInteraction;
import de.ugoe.cs.quest.eventcore.gui.MouseClick;
import de.ugoe.cs.quest.eventcore.gui.ValueSelection;
import de.ugoe.cs.tasktree.keyboardmaps.VirtualKey;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @version $Revision: $ $Date: 21.08.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class MFCEventTypeFactory {
    
    /**
     * <p>
     * the instance of the singleton
     * </p>
     */
    private static MFCEventTypeFactory instance = new MFCEventTypeFactory();

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     */
    private MFCEventTypeFactory() {
        // prevent external instantiation
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    public static MFCEventTypeFactory getInstance() {
        return instance;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param currentRuleName
     * @return
     */
    public IEventType getEventType(String              eventName,
                                   Map<String, String> messageParameters)
    {
        if ("LeftClickButton".equals(eventName)) {
            return new MouseClick(MouseButtonInteraction.Button.LEFT);
        }
        else if ("LeftClickListBox".equals(eventName)) {
            return new ValueSelection<Integer>(getSelectedValue(messageParameters));
        }
        else if ("TabChange".equals(eventName)) {
            return new MouseClick(MouseButtonInteraction.Button.LEFT);
        }
        else if ("LeftClickCommand".equals(eventName)) {
            return new MouseClick(MouseButtonInteraction.Button.LEFT);
        }
        else if ("LeftClickSysCommand".equals(eventName)) {
            return new MouseClick(MouseButtonInteraction.Button.LEFT);
        }
        else if ("NCLeftClickSysCommand".equals(eventName)) {
            return new MouseClick(MouseButtonInteraction.Button.LEFT);
        }
        else if ("LeftClickMenuItemCmd".equals(eventName)) {
            return new MouseClick(MouseButtonInteraction.Button.LEFT);
        }
        else if ("HScroll_TrackBar".equals(eventName)) {
            return new ValueSelection<Integer>(getSelectedValue(messageParameters));
        }
        else if ("VScroll_TrackBar".equals(eventName)) {
            return new ValueSelection<Integer>(getSelectedValue(messageParameters));
        }
        else if ("HScroll_ScrollBar".equals(eventName)) {
            return new MouseClick(MouseButtonInteraction.Button.LEFT);
        }
        else if ("VScroll_ScrollBar".equals(eventName)) {
            return new MouseClick(MouseButtonInteraction.Button.LEFT);
        }
        else if ("VScrollNC".equals(eventName)) {
            return new MouseClick(MouseButtonInteraction.Button.LEFT);
        }
        else if ("LeftClickSetFocus".equals(eventName)) {
            return new KeyboardFocusChange();
        }
        else if ("LeftClickChangeFocus".equals(eventName)) {
            return new KeyboardFocusChange();
        }
        else if ("KeyDown".equals(eventName)) {
            return new KeyPressed(getKey(messageParameters));
        }
        else if ("KeyUp".equals(eventName)) {
            return new KeyReleased(getKey(messageParameters));
        }
        else if ("SysKeyDown".equals(eventName)) {
            return new KeyPressed(getKey(messageParameters));
        }
        else if ("SysKeyUp".equals(eventName)) {
            return new KeyReleased(getKey(messageParameters));
        }
        else if ("LeftClickCoordinates".equals(eventName)) {
            return new MouseClick(MouseButtonInteraction.Button.LEFT);
        }
        else if ("NCLeftClickCoordinates".equals(eventName)) {
            return new MouseClick(MouseButtonInteraction.Button.LEFT);
        }
        else if ("NCLeftClickCoordinates2".equals(eventName)) {
            return new MouseClick(MouseButtonInteraction.Button.LEFT);
        }
        else if ("LeftClickCoordinatesTargetChanged".equals(eventName)) {
            return new MouseClick(MouseButtonInteraction.Button.LEFT);
        }
        else if ("LeftClickCoordinatesTargetChanged2".equals(eventName)) {
            return new MouseClick(MouseButtonInteraction.Button.LEFT);
        }
        else {
            throw new IllegalArgumentException("unknown event name: " + eventName);
        }
    }

    /**
     * @param message
     * @return
     */
    private VirtualKey getKey(Map<String, String> messageParameters) {
        String value = null;
        
        if (messageParameters != null) {
            value = messageParameters.get("key");
        }
        
        if (value == null) {
            throw new IllegalArgumentException
                ("no parameter \"key\" provided for key event. Please correct the event " +
                 "generation rules");
        }
        
        return WindowsVirtualKey.parseVirtualKey(value).getKey();
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param messageParameters
     * @return
     */
    private int getSelectedValue(Map<String, String> messageParameters) {
        String value = null;
        
        if (messageParameters != null) {
            value = messageParameters.get("scrollPos");
        }
        
        if (value == null) {
            throw new IllegalArgumentException
                ("no parameter \"scrollPos\" provided for scroll event. Please correct the event " +
                 "generation rules");
        }
        
        return Integer.parseInt(value);
    }

}
