package de.ugoe.cs.quest.plugin.guitar;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import de.ugoe.cs.quest.plugin.QuestPlugin;

/**
 * <p>
 * Identifier class for the QUEST GUITAR plug-in.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class GUITARPlugin implements QuestPlugin {

	/**
	 * <p>
	 * The command packages of this plug-in.
	 * </p>
	 */
	private final static String[] commandPackages = new String[] { "de.ugoe.cs.quest.plugin.guitar.commands" };

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.plugin.QuestPlugin#getTitle()
	 */
	@Override
	public String getTitle() {
		return "GUITAR-Plugin";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.plugin.QuestPlugin#getCommandPackages()
	 */
	@Override
	public List<String> getCommandPackages() {
		return Collections.unmodifiableList(Arrays.asList(commandPackages));
	}

}
