package de.ugoe.cs.quest.tasktrees.temporalrelation;

import java.util.ArrayList;
import java.util.List;

import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNode;

/**
 * <p>
 * The rule application result describes the result of applying a {@link TemporalRelationshipRule}
 * on a task tree node. It contains a {@link RuleApplicationStatus} and a list of all parent
 * task tree nodes that were created during a rule application. See the description of
 * {@link TemporalRelationshipRule} for more details.
 * </p>
 * 
 * @author Patrick Harms
 */
class RuleApplicationResult {

    /** */
    private RuleApplicationStatus status = RuleApplicationStatus.RULE_NOT_APPLIED;

    /** */
    private List<ITaskTreeNode> newParents = new ArrayList<ITaskTreeNode>();

    /**
     * <p>
     * create a rule application result with a status {@link RuleApplicationStatus#RULE_NOT_APPLIED}
     * </p>
     */
    RuleApplicationResult() {
        // this is the default indicating nothing so far
    }

    /**
     * <p>
     * set the rule application status
     * </p>
     */
    void setRuleApplicationStatus(RuleApplicationStatus status) {
        this.status = status;
    }

    /**
     * <p>
     * return the rule application status
     * </p>
     */
    RuleApplicationStatus getRuleApplicationStatus() {
        return status;
    }

    /**
     * <p>
     * add a further parent node created during the rule application
     * </p>
     */
    void addNewlyCreatedParentNode(ITaskTreeNode newParent) {
        newParents.add(newParent);
    }

    /**
     * <p>
     * return all parent nodes created during the rule application
     * </p>
     */
    List<ITaskTreeNode> getNewlyCreatedParentNodes() {
        return newParents;
    }

}
