package de.ugoe.cs.quest.tasktrees.nodeequality;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.quest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.quest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNodeFactory;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeNodeFactory;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeNode;

/**
 * @author Patrick Harms
 */
public class IterationComparisonRuleTest {

    /**
     *
     */
    @Test
    public void test() {
        NodeEqualityRuleManager manager = new NodeEqualityRuleManager();
        manager.init();
        
        ITaskTreeNodeFactory treeNodeFactory = new TaskTreeNodeFactory();
        ITaskTreeBuilder treeBuilder = new TaskTreeBuilder();
        
        IterationComparisonRule rule = new IterationComparisonRule(manager);
        
        ITaskTreeNode task1 = new TaskTreeNode("task1");
        ITaskTreeNode task2 = new TaskTreeNode("task2");
        
        assertNull(rule.compare(task1, task2));
        
        IIteration iteration1 = treeNodeFactory.createNewIteration();
        assertEquals(NodeEquality.IDENTICAL, rule.compare(iteration1, iteration1));

        IIteration iteration2 = treeNodeFactory.createNewIteration();
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration1, iteration2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration2, iteration1));
        
        treeBuilder.setChild(iteration1, task1);
        
        assertEquals(NodeEquality.UNEQUAL, rule.compare(iteration1, iteration2));
        assertEquals(NodeEquality.UNEQUAL, rule.compare(iteration2, iteration1));
        
        treeBuilder.setChild(iteration2, task1);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration1, iteration2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration2, iteration1));
        
        treeBuilder.setChild(iteration1, task2);
        
        assertEquals(NodeEquality.UNEQUAL, rule.compare(iteration1, iteration2));
        assertEquals(NodeEquality.UNEQUAL, rule.compare(iteration2, iteration1));
        
        treeBuilder.setChild(iteration2, task2);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration1, iteration2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration2, iteration1));
        
        ISelection selection1 = treeNodeFactory.createNewSelection();
        treeBuilder.addChild(selection1, task2);
        treeBuilder.setChild(iteration1, selection1);
        
        assertEquals(NodeEquality.SYNTACTICALLY_EQUAL, rule.compare(iteration1, iteration2));
        assertEquals(NodeEquality.SYNTACTICALLY_EQUAL, rule.compare(iteration2, iteration1));
        
        ISelection selection2 = treeNodeFactory.createNewSelection();
        treeBuilder.addChild(selection2, task2);
        treeBuilder.setChild(iteration2, selection2);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration1, iteration2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(iteration2, iteration1));
        
        assertNull(rule.compare(iteration1, selection1));
        assertNull(rule.compare(selection1, iteration1));
        assertNull(rule.compare(iteration2, selection1));
        assertNull(rule.compare(selection1, iteration2));

        assertNull(rule.compare(iteration1, selection2));
        assertNull(rule.compare(selection2, iteration1));
        assertNull(rule.compare(iteration2, selection2));
        assertNull(rule.compare(selection2, iteration2));
    }

}
