/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.annotations.AnnotationControls;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.EditingModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.functors.MapTransformer;
import org.apache.commons.collections15.map.LazyMap;

public class GraphEditorDemo
extends JApplet
implements Printable {
    private static final long serialVersionUID = -2023243689258876709L;
    Graph<Number, Number> graph = new SparseMultigraph();
    AbstractLayout<Number, Number> layout = new StaticLayout(this.graph, new Dimension(600, 600));
    VisualizationViewer<Number, Number> vv = new VisualizationViewer(this.layout);
    String instructions = "<html><h3>All Modes:</h3><ul><li>Right-click an empty area for <b>Create Vertex</b> popup<li>Right-click on a Vertex for <b>Delete Vertex</b> popup<li>Right-click on a Vertex for <b>Add Edge</b> menus <br>(if there are selected Vertices)<li>Right-click on an Edge for <b>Delete Edge</b> popup<li>Mousewheel scales with a crossover value of 1.0.<p>     - scales the graph layout when the combined scale is greater than 1<p>     - scales the graph view when the combined scale is less than 1</ul><h3>Editing Mode:</h3><ul><li>Left-click an empty area to create a new Vertex<li>Left-click on a Vertex and drag to another Vertex to create an Undirected Edge<li>Shift+Left-click on a Vertex and drag to another Vertex to create a Directed Edge</ul><h3>Picking Mode:</h3><ul><li>Mouse1 on a Vertex selects the vertex<li>Mouse1 elsewhere unselects all Vertices<li>Mouse1+Shift on a Vertex adds/removes Vertex selection<li>Mouse1+drag on a Vertex moves all selected Vertices<li>Mouse1+drag elsewhere selects Vertices in a region<li>Mouse1+Shift+drag adds selection of Vertices in a new region<li>Mouse1+CTRL on a Vertex selects the vertex and centers the display on it<li>Mouse1 double-click on a vertex or edge allows you to edit the label</ul><h3>Transforming Mode:</h3><ul><li>Mouse1+drag pans the graph<li>Mouse1+Shift+drag rotates the graph<li>Mouse1+CTRL(or Command)+drag shears the graph<li>Mouse1 double-click on a vertex or edge allows you to edit the label</ul><h3>Annotation Mode:</h3><ul><li>Mouse1 begins drawing of a Rectangle<li>Mouse1+drag defines the Rectangle shape<li>Mouse1 release adds the Rectangle as an annotation<li>Mouse1+Shift begins drawing of an Ellipse<li>Mouse1+Shift+drag defines the Ellipse shape<li>Mouse1+Shift release adds the Ellipse as an annotation<li>Mouse3 shows a popup to input text, which will become<li>a text annotation on the graph at the mouse location</ul></html>";

    public GraphEditorDemo() {
        this.vv.setBackground(Color.white);
        this.vv.getRenderContext().setVertexLabelTransformer(MapTransformer.getInstance(LazyMap.decorate(new HashMap(), new ToStringLabeller())));
        this.vv.getRenderContext().setEdgeLabelTransformer(MapTransformer.getInstance(LazyMap.decorate(new HashMap(), new ToStringLabeller())));
        this.vv.setVertexToolTipTransformer(this.vv.getRenderContext().getVertexLabelTransformer());
        Container content = this.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add((Component)panel);
        VertexFactory vertexFactory = new VertexFactory();
        EdgeFactory edgeFactory = new EdgeFactory();
        EditingModalGraphMouse graphMouse = new EditingModalGraphMouse(this.vv.getRenderContext(), (Factory)vertexFactory, (Factory)edgeFactory);
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        graphMouse.setMode(ModalGraphMouse.Mode.EDITING);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(GraphEditorDemo.this.vv, 1.1f, GraphEditorDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(GraphEditorDemo.this.vv, 0.9090909f, GraphEditorDemo.this.vv.getCenter());
            }
        });
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(GraphEditorDemo.this.vv, GraphEditorDemo.this.instructions);
            }
        });
        AnnotationControls annotationControls = new AnnotationControls(graphMouse.getAnnotatingPlugin());
        JPanel controls = new JPanel();
        controls.add(plus);
        controls.add(minus);
        JComboBox modeBox = graphMouse.getModeComboBox();
        controls.add(modeBox);
        controls.add(annotationControls.getAnnotationsToolBar());
        controls.add(help);
        content.add((Component)controls, "South");
    }

    public void writeJPEGImage(File file) {
        int width = this.vv.getWidth();
        int height = this.vv.getHeight();
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D graphics = bi.createGraphics();
        this.vv.paint((Graphics)graphics);
        graphics.dispose();
        try {
            ImageIO.write((RenderedImage)bi, "jpeg", file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        this.vv.setDoubleBuffered(false);
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.vv.paint((Graphics)g2d);
        this.vv.setDoubleBuffered(true);
        return 0;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        final GraphEditorDemo demo = new GraphEditorDemo();
        JMenu menu = new JMenu("File");
        menu.add(new AbstractAction("Make Image"){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                int option = chooser.showSaveDialog(demo);
                if (option == 0) {
                    File file = chooser.getSelectedFile();
                    demo.writeJPEGImage(file);
                }
            }
        });
        menu.add(new AbstractAction("Print"){

            public void actionPerformed(ActionEvent e) {
                PrinterJob printJob = PrinterJob.getPrinterJob();
                printJob.setPrintable(demo);
                if (printJob.printDialog()) {
                    try {
                        printJob.print();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(menu);
        frame.setJMenuBar(menuBar);
        frame.getContentPane().add(demo);
        frame.pack();
        frame.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EdgeFactory
    implements Factory<Number> {
        int i = 0;

        EdgeFactory() {
        }

        @Override
        public Number create() {
            return this.i++;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VertexFactory
    implements Factory<Number> {
        int i = 0;

        VertexFactory() {
        }

        @Override
        public Number create() {
            return this.i++;
        }
    }
}

