/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassNotFoundExceptionParser {
    private static final Pattern BCEL_MISSING_CLASS_PATTERN = Pattern.compile("^.*while looking for class ([^:]*):.*$");
    private static final Pattern TYPE_REPOSITORY_MISSING_CLASS_PATTERN = Pattern.compile("^Class ([^ ]*) cannot be resolved.*$");
    private static final Pattern[] patternList;

    @DottedClassName
    public static String getMissingClassName(ClassNotFoundException ex) {
        String resourceName;
        Throwable cause = ex.getCause();
        if (cause instanceof ResourceNotFoundException && (resourceName = ((ResourceNotFoundException)cause).getResourceName()) != null) {
            ClassDescriptor classDesc = DescriptorFactory.createClassDescriptorFromResourceName(resourceName);
            return classDesc.toDottedClassName();
        }
        if (ex.getMessage() == null) {
            return null;
        }
        for (Pattern pattern : patternList) {
            Matcher matcher = pattern.matcher(ex.getMessage());
            if (!matcher.matches()) continue;
            String className = matcher.group(1);
            ClassName.assertIsDotted(className);
            return className;
        }
        return null;
    }

    static {
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        list.add(BCEL_MISSING_CLASS_PATTERN);
        list.add(TYPE_REPOSITORY_MISSING_CLASS_PATTERN);
        patternList = list.toArray(new Pattern[list.size()]);
    }
}

