/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.eventbench.jfcmonitor;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class JarLauncher {
    private String jarfile;
    private String[] args;
    final String workingDir = System.getProperty("user.dir") + "/";
    private String[] classPath = new String[0];
    private String mainClassName = "";

    public JarLauncher(String jarfile, String[] args) {
        this.jarfile = jarfile;
        this.args = Arrays.copyOf(args, args.length);
    }

    public void exec() {
        try {
            this.getInfoFromJar();
            this.initClassLoader();
            this.runMain();
        }
        catch (JarLaunchException e) {
            System.err.println("Failure to launch application.");
            System.err.println(e.getMessage());
        }
    }

    private void getInfoFromJar() throws JarLaunchException {
        JarInputStream jarInputStream;
        try {
            jarInputStream = new JarInputStream(new FileInputStream(this.workingDir + this.jarfile));
        }
        catch (FileNotFoundException e) {
            throw new JarLaunchException(e);
        }
        catch (IOException e) {
            throw new JarLaunchException(e);
        }
        Manifest manifest = jarInputStream.getManifest();
        this.mainClassName = manifest.getMainAttributes().getValue("Main-Class");
        String jarClassPath = manifest.getMainAttributes().getValue("Class-Path");
        String[] jarClassPathElements = jarClassPath.split(" ");
        this.classPath = new String[jarClassPathElements.length];
        for (int i = 0; i < jarClassPathElements.length; ++i) {
            this.classPath[i] = "file:" + this.workingDir + jarClassPathElements[i];
        }
        try {
            jarInputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initClassLoader() throws JarLaunchException {
        Method method;
        URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        try {
            method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        }
        catch (SecurityException e) {
            throw new JarLaunchException("addURL method of URLClassLoader not accessible via reflection.");
        }
        catch (NoSuchMethodException e) {
            throw new JarLaunchException("URLClassLoader does not have addURL method. Should be impossible!!");
        }
        method.setAccessible(true);
        try {
            method.invoke((Object)classLoader, new URL("file:" + this.workingDir + this.jarfile));
            for (String element : this.classPath) {
                method.invoke((Object)classLoader, new URL(element));
            }
        }
        catch (IllegalArgumentException e) {
            throw new JarLaunchException("Illegal arguments for addURL method. Should be impossible!!");
        }
        catch (MalformedURLException e) {
            throw new JarLaunchException(e);
        }
        catch (IllegalAccessException e) {
            throw new JarLaunchException("addURL method of URLClassLoader not accessible via reflection.");
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void runMain() throws JarLaunchException {
        Method mainMethod;
        Class<?> mainClass;
        try {
            mainClass = Class.forName(this.mainClassName);
        }
        catch (ClassNotFoundException e) {
            throw new JarLaunchException("Main class not found: " + this.mainClassName);
        }
        try {
            mainMethod = mainClass.getMethod("main", String[].class);
        }
        catch (SecurityException e) {
            throw new JarLaunchException("Main method not accessible.");
        }
        catch (NoSuchMethodException e) {
            throw new JarLaunchException("Main method not found.");
        }
        try {
            mainMethod.invoke(null, new Object[]{this.args});
        }
        catch (IllegalArgumentException e) {
            throw new JarLaunchException("Illegal arguments for main method. Should be impossible!!");
        }
        catch (IllegalAccessException e) {
            throw new JarLaunchException("Main method not accessible.");
        }
        catch (InvocationTargetException e) {
            throw new JarLaunchException(e);
        }
    }

    private static class JarLaunchException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public JarLaunchException(String string) {
            super(string);
        }

        public JarLaunchException(Exception e) {
            super(e);
        }
    }
}

