/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.guitar.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class GUITARLog {
    public static final String LOGFILE_NAME_SYSTEM_PROPERTY = "logfile.name";
    public static Logger log;
    private static final String LOG_LAYOUT_PATTERN = "%-6r [%t] %-5p - %n";
    private static final String GUITAR_DEFAULT_LOG = "GUITAR-Default.log";
    private static Level level;

    public static void Debug(String str) {
        if (Level.DEBUG.isGreaterOrEqual((Priority)level)) {
            System.out.println("Debug: " + str);
        }
    }

    public static void Info(String str) {
        if (Level.INFO.isGreaterOrEqual((Priority)level)) {
            System.out.println("Info: " + str);
        }
    }

    public static void Error(String str) {
        if (Level.ERROR.isGreaterOrEqual((Priority)level)) {
            System.out.println("Error: " + str);
        }
    }

    static {
        level = Level.DEBUG;
        log = Logger.getLogger(GUITARLog.class);
        if (System.getProperty(LOGFILE_NAME_SYSTEM_PROPERTY) == null) {
            System.setProperty(LOGFILE_NAME_SYSTEM_PROPERTY, GUITAR_DEFAULT_LOG);
        }
        if (System.getProperty("log4j.configuration") == null) {
            Properties props = new Properties();
            InputStream stream = null;
            try {
                stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("log/guitar-default.glc");
                if (stream != null) {
                    props.load(stream);
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                System.exit(-1);
            }
            PropertyConfigurator.configure((Properties)props);
            if (stream == null) {
                System.err.println("Log configuration file not found");
                PatternLayout layout = new PatternLayout();
                layout.setConversionPattern(LOG_LAYOUT_PATTERN);
                FileAppender file = null;
                try {
                    String logFileName = System.getProperty(LOGFILE_NAME_SYSTEM_PROPERTY);
                    file = new FileAppender((Layout)layout, logFileName, false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                log.addAppender(file);
                log.setLevel(level);
            }
        } else {
            log.debug((Object)"log4j was installed");
        }
    }
}

