package de.ugoe.cs.quest.tasktrees.nodeequality;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.quest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.quest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNodeFactory;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeNodeFactory;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeNode;

/**
 * @author Patrick Harms
 */
public class SelectionComparisonRuleTest {

    /**
     * 
     */
    @Test
    public void test() {
        NodeEqualityRuleManager manager = new NodeEqualityRuleManager();
        manager.init();
        
        ITaskTreeNodeFactory treeNodeFactory = new TaskTreeNodeFactory();
        ITaskTreeBuilder treeBuilder = new TaskTreeBuilder();
        
        SelectionComparisonRule rule = new SelectionComparisonRule(manager);
        
        ITaskTreeNode task1 = new TaskTreeNode("task1");
        ITaskTreeNode task2 = new TaskTreeNode("task2");
        
        assertNull(rule.compare(task1, task2));
        
        ISelection selection1 = treeNodeFactory.createNewSelection();
        assertEquals(NodeEquality.IDENTICAL, rule.compare(selection1, selection1));

        ISelection selection2 = treeNodeFactory.createNewSelection();
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(selection1, selection2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(selection2, selection1));
        
        treeBuilder.addChild(selection1, task1);
        
        assertEquals(NodeEquality.UNEQUAL, rule.compare(selection1, selection2));
        assertEquals(NodeEquality.UNEQUAL, rule.compare(selection2, selection1));
        
        treeBuilder.addChild(selection2, task1);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(selection1, selection2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(selection2, selection1));
        
        treeBuilder.addChild(selection1, task2);
        
        assertEquals(NodeEquality.UNEQUAL, rule.compare(selection1, selection2));
        assertEquals(NodeEquality.UNEQUAL, rule.compare(selection2, selection1));
        
        treeBuilder.addChild(selection2, task2);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(selection1, selection2));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(selection2, selection1));
        
        ISelection selection3 = treeNodeFactory.createNewSelection();
        treeBuilder.addChild(selection3, task2);
        treeBuilder.addChild(selection3, task1);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(selection1, selection3));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(selection3, selection1));
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(selection2, selection3));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(selection3, selection2));

        ISequence sequence = treeNodeFactory.createNewSequence();
        assertNull(rule.compare(selection1, sequence));
        assertNull(rule.compare(sequence, selection1));
        assertNull(rule.compare(selection2, sequence));
        assertNull(rule.compare(sequence, selection2));
        assertNull(rule.compare(selection3, sequence));
        assertNull(rule.compare(sequence, selection3));
    }

}
