package de.ugoe.cs.quest.usageprofiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.eventcore.StringEventType;
import de.ugoe.cs.quest.usageprofiles.HighOrderMarkovModel;

import java.util.Random;
import org.junit.*;

import static org.junit.Assert.*;

/**
 * The class <code>HighOrderMarkovModelTest</code> contains tests for the class
 * <code>{@link HighOrderMarkovModel}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class HighOrderMarkovModelTest {

	Collection<List<Event>> sequences;

	@Test
	public void testHighOrderMarkovModel_1() throws Exception {
		int maxOrder = 1;
		Random r = new Random();

		HighOrderMarkovModel result = new HighOrderMarkovModel(maxOrder, r);

		assertNotNull(result);
		assertEquals(r, result.r);
		assertEquals(maxOrder + 1, result.trieOrder);
	}

	@Test
	public void testHighOrderMarkovModel_2() throws Exception {
		int maxOrder = 0;
		Random r = new Random();

		HighOrderMarkovModel result = new HighOrderMarkovModel(maxOrder, r);

		assertNotNull(result);
		assertEquals(r, result.r);
		assertEquals(maxOrder + 1, result.trieOrder);
	}

	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testHighOrderMarkovModel_3() throws Exception {
		int maxOrder = 1;
		Random r = null;

		new HighOrderMarkovModel(maxOrder, r);
	}

	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testHighOrderMarkovModel_4() throws Exception {
		int maxOrder = -1;
		Random r = new Random();

		new HighOrderMarkovModel(maxOrder, r);
	}

	@Test
	public void testGetProbability_1() throws Exception {
		int markovOrder = 1;
		HighOrderMarkovModel fixture = new HighOrderMarkovModel(markovOrder,
				new Random());
		fixture.train(sequences);

		List<Event> context = new ArrayList<Event>();
		context.add(new Event(new StringEventType("a")));

		Event symbol = new Event(new StringEventType("b"));

		double result = fixture.getProbability(context, symbol);

		assertEquals(2.0d / 5.0, result, 0.0001);
	}

	@Test
	public void testGetProbability_2() throws Exception {
		int markovOrder = 1;
		HighOrderMarkovModel fixture = new HighOrderMarkovModel(markovOrder,
				new Random());
		fixture.train(sequences);

		List<Event> context = new ArrayList<Event>();
		context.add(new Event(new StringEventType("a")));

		Event symbol = new Event(new StringEventType("r"));

		double result = fixture.getProbability(context, symbol);

		assertEquals(0.0d / 5.0, result, 0.0001);
	}

	@Test
	public void testGetProbability_3() throws Exception {
		int markovOrder = 1;
		HighOrderMarkovModel fixture = new HighOrderMarkovModel(markovOrder,
				new Random());
		fixture.train(sequences);

		List<Event> context = new ArrayList<Event>();
		context.add(new Event(new StringEventType("a")));

		Event symbol = new Event(new StringEventType("c"));

		double result = fixture.getProbability(context, symbol);

		assertEquals(1.0d / 5.0, result, 0.0001);
	}

	@Test
	public void testGetProbability_4() throws Exception {
		int markovOrder = 1;
		HighOrderMarkovModel fixture = new HighOrderMarkovModel(markovOrder,
				new Random());
		fixture.train(sequences);

		List<Event> context = new ArrayList<Event>();
		context.add(Event.STARTEVENT);
		context.add(new Event(new StringEventType("a")));

		Event symbol = new Event(new StringEventType("b"));

		double result = fixture.getProbability(context, symbol);

		assertEquals(2.0d / 5.0, result, 0.0001);
	}

	@Test
	public void testGetProbability_5() throws Exception {
		int markovOrder = 2;
		HighOrderMarkovModel fixture = new HighOrderMarkovModel(markovOrder,
				new Random());
		fixture.train(sequences);

		List<Event> context = new ArrayList<Event>();
		context.add(Event.STARTEVENT);
		context.add(new Event(new StringEventType("a")));

		Event symbol = new Event(new StringEventType("b"));

		double result = fixture.getProbability(context, symbol);

		assertEquals(1.0d, result, 0.0001);
	}

	@Test
	public void testGetProbability_6() throws Exception {
		int markovOrder = 2;
		HighOrderMarkovModel fixture = new HighOrderMarkovModel(markovOrder,
				new Random());
		fixture.train(sequences);

		List<Event> context = new ArrayList<Event>();
		context.add(Event.STARTEVENT);
		context.add(new Event(new StringEventType("b")));

		Event symbol = new Event(new StringEventType("b"));

		double result = fixture.getProbability(context, symbol);

		assertEquals(0.0d, result, 0.0001);
	}

	@Test
	public void testGetProbability_7() throws Exception {
		int markovOrder = 0;
		HighOrderMarkovModel fixture = new HighOrderMarkovModel(markovOrder,
				new Random());
		fixture.train(sequences);

		List<Event> context = new ArrayList<Event>();
		context.add(Event.STARTEVENT);
		context.add(new Event(new StringEventType("b")));

		Event symbol = new Event(new StringEventType("a"));

		double result = fixture.getProbability(context, symbol);

		assertEquals(5.0d / 13.0, result, 0.0001);
	}

	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testGetProbability_8() throws Exception {
		int markovOrder = 0;
		HighOrderMarkovModel fixture = new HighOrderMarkovModel(markovOrder,
				new Random());
		fixture.train(sequences);

		List<Event> context = new ArrayList<Event>();
		context.add(Event.STARTEVENT);
		context.add(new Event(new StringEventType("b")));

		Event symbol = null;

		fixture.getProbability(context, symbol);
	}

	@Test(expected = java.lang.IllegalArgumentException.class)
	public void testGetProbability_9() throws Exception {
		int markovOrder = 0;
		HighOrderMarkovModel fixture = new HighOrderMarkovModel(markovOrder,
				new Random());
		fixture.train(sequences);

		List<Event> context = null;

		Event symbol = new Event(new StringEventType("b"));

		fixture.getProbability(context, symbol);
	}

	@Before
	public void setUp() throws Exception {
		List<Event> sequence = new ArrayList<Event>();
		sequence.add(new Event(new StringEventType("a")));
		sequence.add(new Event(new StringEventType("b")));
		sequence.add(new Event(new StringEventType("r")));
		sequence.add(new Event(new StringEventType("a")));
		sequence.add(new Event(new StringEventType("c")));
		sequence.add(new Event(new StringEventType("a")));
		sequence.add(new Event(new StringEventType("d")));
		sequence.add(new Event(new StringEventType("a")));
		sequence.add(new Event(new StringEventType("b")));
		sequence.add(new Event(new StringEventType("r")));
		sequence.add(new Event(new StringEventType("a")));

		sequences = new ArrayList<List<Event>>();
		sequences.add(sequence);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(HighOrderMarkovModelTest.class);
	}
}