/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.BytecodeScanner;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.InnerClassAccess;
import edu.umd.cs.findbugs.ba.XField;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESTATIC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InnerClassAccessMap {
    private static final boolean DEBUG = SystemProperties.getBoolean("icam.debug");
    private Map<String, Map<String, InnerClassAccess>> classToAccessMap = new HashMap<String, Map<String, InnerClassAccess>>(3);
    private static final Map<String, InnerClassAccess> emptyMap = new HashMap<String, InnerClassAccess>();

    public static InnerClassAccessMap create() {
        return new InnerClassAccessMap();
    }

    public InnerClassAccess getInnerClassAccess(String className, String methodName) throws ClassNotFoundException {
        Map<String, InnerClassAccess> map = this.getAccessMapForClass(className);
        return map.get(methodName);
    }

    public InnerClassAccess getInnerClassAccess(INVOKESTATIC inv, ConstantPoolGen cpg) throws ClassNotFoundException {
        String methodName = inv.getMethodName(cpg);
        if (methodName.startsWith("access$")) {
            String className = inv.getClassName(cpg);
            return this.getInnerClassAccess(className, methodName);
        }
        return null;
    }

    public void clearCache() {
        this.classToAccessMap.clear();
    }

    private InnerClassAccessMap() {
    }

    private static int toInt(byte b) {
        int value = b & 0x7F;
        if ((b & 0x80) != 0) {
            value |= 0x80;
        }
        return value;
    }

    private static int getIndex(byte[] instructionList, int index) {
        return InnerClassAccessMap.toInt(instructionList[index + 1]) << 8 | InnerClassAccessMap.toInt(instructionList[index + 2]);
    }

    private Map<String, InnerClassAccess> getAccessMapForClass(String className) throws ClassNotFoundException {
        Map<String, InnerClassAccess> map = this.classToAccessMap.get(className);
        if (map == null) {
            map = new HashMap<String, InnerClassAccess>(3);
            if (!className.startsWith("[")) {
                Method[] methodList;
                JavaClass javaClass = Repository.lookupClass(className);
                for (Method method : methodList = javaClass.getMethods()) {
                    Code code;
                    String methodName = method.getName();
                    if (!methodName.startsWith("access$") || (code = method.getCode()) == null) continue;
                    if (DEBUG) {
                        System.out.println("Analyzing " + className + "." + method.getName() + " as an inner-class access method...");
                    }
                    byte[] instructionList = code.getCode();
                    String methodSig = method.getSignature();
                    InstructionCallback callback = new InstructionCallback(javaClass, methodName, methodSig, instructionList);
                    try {
                        new BytecodeScanner().scan(instructionList, callback);
                    }
                    catch (LookupFailure lf) {
                        throw lf.getException();
                    }
                    InnerClassAccess access = callback.getAccess();
                    if (DEBUG) {
                        System.out.println((access != null ? "IS" : "IS NOT") + " an inner-class access method");
                    }
                    if (access == null) continue;
                    map.put(methodName, access);
                }
            }
            map = map.size() == 0 ? emptyMap : new HashMap<String, InnerClassAccess>(map);
            this.classToAccessMap.put(className, map);
        }
        return map;
    }

    private static class InstructionCallback
    implements BytecodeScanner.Callback {
        private JavaClass javaClass;
        private String methodName;
        private String methodSig;
        private byte[] instructionList;
        private InnerClassAccess access;
        private int accessCount;

        public InstructionCallback(JavaClass javaClass, String methodName, String methodSig, byte[] instructionList) {
            this.javaClass = javaClass;
            this.methodName = methodName;
            this.methodSig = methodSig;
            this.instructionList = instructionList;
            this.access = null;
            this.accessCount = 0;
        }

        public void handleInstruction(int opcode, int index) {
            switch (opcode) {
                case 180: 
                case 181: {
                    this.setField(InnerClassAccessMap.getIndex(this.instructionList, index), false, opcode == 180);
                    break;
                }
                case 178: 
                case 179: {
                    this.setField(InnerClassAccessMap.getIndex(this.instructionList, index), true, opcode == 178);
                }
            }
        }

        public InnerClassAccess getAccess() {
            return this.access;
        }

        private void setField(int cpIndex, boolean isStatic, boolean isLoad) {
            String fieldSig;
            ConstantNameAndType nameAndType;
            String fieldName;
            ConstantFieldref fieldref;
            ++this.accessCount;
            if (this.accessCount != 1) {
                this.access = null;
                return;
            }
            ConstantPool cp = this.javaClass.getConstantPool();
            ConstantClass cls = (ConstantClass)cp.getConstant((fieldref = (ConstantFieldref)cp.getConstant(cpIndex)).getClassIndex());
            String className = cls.getBytes(cp).replace('/', '.');
            XField xfield = Hierarchy.findXField(className, fieldName = (nameAndType = (ConstantNameAndType)cp.getConstant(fieldref.getNameAndTypeIndex())).getName(cp), fieldSig = nameAndType.getSignature(cp), isStatic);
            if (xfield != null && xfield.isStatic() == isStatic && this.isValidAccessMethod(this.methodSig, xfield, isLoad)) {
                this.access = new InnerClassAccess(this.methodName, this.methodSig, xfield, isLoad);
            }
        }

        private boolean isValidAccessMethod(String methodSig, XField field, boolean isLoad) {
            int paramsEnd = methodSig.indexOf(41);
            if (paramsEnd < 0) {
                return false;
            }
            String methodParams = methodSig.substring(0, paramsEnd + 1);
            String methodReturnType = methodSig.substring(paramsEnd + 1);
            String classSig = "L" + this.javaClass.getClassName().replace('.', '/') + ";";
            StringBuilder buf = new StringBuilder();
            buf.append('(');
            if (!field.isStatic()) {
                buf.append(classSig);
            }
            if (!isLoad) {
                buf.append(field.getSignature());
            }
            buf.append(')');
            String expectedMethodParams = buf.toString();
            if (!methodParams.equals(expectedMethodParams)) {
                if (DEBUG) {
                    System.out.println("In " + this.javaClass.getClassName() + "." + this.methodName + " expected params " + expectedMethodParams + ", saw " + methodParams);
                    System.out.println(isLoad ? "LOAD" : "STORE");
                }
                return false;
            }
            if (!methodReturnType.equals("V") && !methodReturnType.equals(field.getSignature())) {
                if (DEBUG) {
                    System.out.println("In " + this.javaClass.getClassName() + "." + this.methodName + " expected return type V or " + field.getSignature() + ", saw " + methodReturnType);
                    System.out.println(isLoad ? "LOAD" : "STORE");
                }
                return false;
            }
            return true;
        }
    }

    private static class LookupFailure
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final ClassNotFoundException exception;

        public LookupFailure(ClassNotFoundException exception) {
            this.exception = exception;
        }

        public ClassNotFoundException getException() {
            return this.exception;
        }
    }
}

