package de.ugoe.cs.util.console.listener;

import java.util.logging.Level;

import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Interface for listeners observing traces stream to the {@link Console}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public interface ITraceListener {
	/**
	 * <p>
	 * Receives messages send to the trace stream of the {@link Console}.
	 * </p>
	 * 
	 * @param traceMessage
	 *            trace message
	 * @param level
	 *            trace level
	 */
	public void traceMsg(String traceMessage, Level level);
}
