
package de.ugoe.cs.quest.plugin.mfc.eventcore;

import de.ugoe.cs.tasktree.keyboardmaps.VirtualKey;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
// -------------------------------------------------------------------------------------------------

public enum WindowsVirtualKey
{
    // VK_LBUTTON (0x01, "Left mouse button"),
    // VK_RBUTTON (0x02, "Right mouse button"),
    VK_CANCEL(0x03, VirtualKey.CANCEL),
    // VK_MBUTTON (0x04, "Middle mouse button (three-button mouse)"),
    // VK_XBUTTON1 (0x05, "X1 mouse button"),
    // VK_XBUTTON2 (0x06, "X2 mouse button"),
    // - (0x07, "Undefined"),
    VK_BACK(0x08, VirtualKey.BACK_SPACE),
    VK_TAB(0x09, VirtualKey.TAB),
    // - (0x0A-0B, "Reserved"),
    VK_CLEAR(0x0C, VirtualKey.CLEAR),
    VK_RETURN(0x0D, VirtualKey.ENTER),
    // - (0x0E-0F, "Undefined"),
    VK_SHIFT(0x10, VirtualKey.SHIFT),
    VK_CONTROL(0x11, VirtualKey.CONTROL),
    VK_MENU(0x12, VirtualKey.ALT),
    VK_PAUSE(0x13, VirtualKey.PAUSE),
    VK_CAPITAL(0x14, VirtualKey.CAPS_LOCK),
    VK_KANA(0x15, VirtualKey.KANA),
    // VK_HANGUEL (0x15, VirtualKey.HANGUEL),
    // VK_HANGUL (0x15, "IME Hangul mode"),
    // - (0x16, "Undefined"),
    // VK_JUNJA (0x17, VirtualKey.J),
    VK_FINAL(0x18, VirtualKey.FINAL),
    // VK_HANJA (0x19, "IME Hanja mode"),
    VK_KANJI(0x19, VirtualKey.KANJI),
    // - (0x1A, "Undefined"),
    VK_ESCAPE(0x1B, VirtualKey.ESCAPE), VK_CONVERT(0x1C, VirtualKey.CONVERT),
    VK_NONCONVERT(0x1D, VirtualKey.NONCONVERT),
    VK_ACCEPT(0x1E, VirtualKey.ACCEPT),
    VK_MODECHANGE(0x1F, VirtualKey.MODECHANGE),

    VK_SPACE(0x20, VirtualKey.SPACE),
    VK_PRIOR(0x21, VirtualKey.PAGE_UP),
    VK_NEXT(0x22, VirtualKey.PAGE_DOWN),
    VK_END(0x23, VirtualKey.END),
    VK_HOME(0x24, VirtualKey.HOME),
    VK_LEFT(0x25, VirtualKey.LEFT),
    VK_UP(0x26, VirtualKey.UP),
    VK_RIGHT(0x27, VirtualKey.RIGHT),
    VK_DOWN(0x28, VirtualKey.DOWN),
    // VK_SELECT (0x29, VirtualKey.),
    VK_PRINT(0x2A, VirtualKey.PRINTSCREEN),
    // VK_EXECUTE (0x2B, VirtualKey.EXECUTE),
    VK_SNAPSHOT(0x2C, VirtualKey.PRINTSCREEN), VK_INSERT(0x2D, VirtualKey.INSERT), VK_DELETE(0x2E,
        VirtualKey.DELETE), VK_HELP(0x2F, VirtualKey.HELP), DIGIT_0(0x30, VirtualKey.DIGIT_0),
    DIGIT_1(0x31, VirtualKey.DIGIT_1), DIGIT_2(0x32, VirtualKey.DIGIT_2), DIGIT_3(0x33,
        VirtualKey.DIGIT_3), DIGIT_4(0x34, VirtualKey.DIGIT_4), DIGIT_5(0x35, VirtualKey.DIGIT_5),
    DIGIT_6(0x36, VirtualKey.DIGIT_6),
    DIGIT_7(0x37, VirtualKey.DIGIT_7),
    DIGIT_8(0x38, VirtualKey.DIGIT_8),
    DIGIT_9(0x39, VirtualKey.DIGIT_9),
    // - (0x3A-40, "Undefined"),
    A(0x41, VirtualKey.LETTER_A), B(0x42, VirtualKey.LETTER_B), C(0x43, VirtualKey.LETTER_C), D(
        0x44, VirtualKey.LETTER_D), E(0x45, VirtualKey.LETTER_E), F(0x46, VirtualKey.LETTER_F), G(
        0x47, VirtualKey.LETTER_G), H(0x48, VirtualKey.LETTER_H), I(0x49, VirtualKey.LETTER_I), J(
        0x4A, VirtualKey.LETTER_J), K(0x4B, VirtualKey.LETTER_K), L(0x4C, VirtualKey.LETTER_L), M(
        0x4D, VirtualKey.LETTER_M), N(0x4E, VirtualKey.LETTER_N), O(0x4F, VirtualKey.LETTER_O), P(
        0x50, VirtualKey.LETTER_P), Q(0x51, VirtualKey.LETTER_Q), R(0x52, VirtualKey.LETTER_R), S(
        0x53, VirtualKey.LETTER_S),
    T(0x54, VirtualKey.LETTER_T),
    U(0x55, VirtualKey.LETTER_U),
    V(0x56, VirtualKey.LETTER_V),
    W(0x57, VirtualKey.LETTER_W),
    X(0x58, VirtualKey.LETTER_X),
    Y(0x59, VirtualKey.LETTER_Y),
    Z(0x5A, VirtualKey.LETTER_Z),
    VK_LWIN(0x5B, VirtualKey.WINDOWS),
    VK_RWIN(0x5C, VirtualKey.WINDOWS),
    // VK_APPS (0x5D, "Applications key (Natural keyboard)"),
    // - (0x5E, "Reserved"),
    // VK_SLEEP (0x5F, VirtualKey.SLEEP),
    VK_NUMPAD0(0x60, VirtualKey.NUMPAD_0), VK_NUMPAD1(0x61, VirtualKey.NUMPAD_1), VK_NUMPAD2(0x62,
        VirtualKey.NUMPAD_2), VK_NUMPAD3(0x63, VirtualKey.NUMPAD_3), VK_NUMPAD4(0x64,
        VirtualKey.NUMPAD_4), VK_NUMPAD5(0x65, VirtualKey.NUMPAD_5), VK_NUMPAD6(0x66,
        VirtualKey.NUMPAD_6), VK_NUMPAD7(0x67, VirtualKey.NUMPAD_7), VK_NUMPAD8(0x68,
        VirtualKey.NUMPAD_8), VK_NUMPAD9(0x69, VirtualKey.NUMPAD_9), VK_MULTIPLY(0x6A,
        VirtualKey.MULTIPLY), VK_ADD(0x6B, VirtualKey.ADD),
    VK_SEPARATOR(0x6C, VirtualKey.SEPARATOR), VK_SUBTRACT(0x6D, VirtualKey.SUBTRACT), VK_DECIMAL(
        0x6E, VirtualKey.DECIMAL), VK_DIVIDE(0x6F, VirtualKey.DIVIDE), VK_F1(0x70, VirtualKey.F1),
    VK_F2(0x71, VirtualKey.F2), VK_F3(0x72, VirtualKey.F3), VK_F4(0x73, VirtualKey.F4), VK_F5(0x74,
        VirtualKey.F5), VK_F6(0x75, VirtualKey.F6), VK_F7(0x76, VirtualKey.F7), VK_F8(0x77,
        VirtualKey.F8), VK_F9(0x78, VirtualKey.F9), VK_F10(0x79, VirtualKey.F10), VK_F11(0x7A,
        VirtualKey.F11), VK_F12(0x7B, VirtualKey.F12), VK_F13(0x7C, VirtualKey.F13), VK_F14(0x7D,
        VirtualKey.F14), VK_F15(0x7E, VirtualKey.F15), VK_F16(0x7F, VirtualKey.F16), VK_F17(0x80,
        VirtualKey.F17), VK_F18(0x81, VirtualKey.F18), VK_F19(0x82, VirtualKey.F19), VK_F20(0x83,
        VirtualKey.F20), VK_F21(0x84, VirtualKey.F21), VK_F22(0x85, VirtualKey.F22), VK_F23(0x86,
        VirtualKey.F23), VK_F24(0x87, VirtualKey.F24),
    // - (0x88-8F, "Unassigned"),
    VK_NUMLOCK(0x90, VirtualKey.NUM_LOCK),
    VK_SCROLL(0x91, VirtualKey.SCROLL_LOCK),
    // - (0x92-96, "OEM specific"),
    // - (0x97-9F, "Unassigned"),
    VK_LSHIFT(0xA0, VirtualKey.SHIFT), VK_RSHIFT(0xA1, VirtualKey.SHIFT), VK_LCONTROL(0xA2,
        VirtualKey.CONTROL), VK_RCONTROL(0xA3, VirtualKey.CONTROL), VK_LMENU(0xA4, VirtualKey.ALT),
    VK_RMENU(0xA5, VirtualKey.ALT_GRAPH),
    // VK_BROWSER_BACK (0xA6, VirtualKey.BROWSER_BACK),
    // VK_BROWSER_FORWARD (0xA7, VirtualKey.BROWSER_FORWARD),
    VK_BROWSER_REFRESH(0xA8, VirtualKey.F5), VK_BROWSER_STOP(0xA9, VirtualKey.STOP),
    // VK_BROWSER_SEARCH (0xAA, VirtualKey.BROWSER_SEARCH),
    // VK_BROWSER_FAVORITES (0xAB, VirtualKey.BROWSER_FAVORITES),
    // VK_BROWSER_HOME (0xAC, VirtualKey.BROWSER_HOME),
    // VK_VOLUME_MUTE (0xAD, VirtualKey.VOLUME_MUTE),
    // VK_VOLUME_DOWN (0xAE, VirtualKey.VOLUME_DOWN),
    // VK_VOLUME_UP (0xAF, VirtualKey.VOLUME_UP),
    // VK_MEDIA_NEXT_TRACK (0xB0, VirtualKey.MEDIA_NEXT_TRACK),
    // VK_MEDIA_PREV_TRACK (0xB1, VirtualKey.MEDIA_PREV_TRACK),
    // VK_MEDIA_STOP (0xB2, VirtualKey.MEDIA_STOP),
    // VK_MEDIA_PLAY_PAUSE (0xB3, VirtualKey.MEDIA_PLAY_PAUSE),
    // VK_LAUNCH_MAIL (0xB4, VirtualKey.LAUNCH_MAIL),
    // VK_LAUNCH_MEDIA_SELECT (0xB5, VirtualKey.LAUNCH_MEDIA_SELECT),
    // VK_LAUNCH_APP1 (0xB6, VirtualKey.LAUNCH_APP1),
    // VK_LAUNCH_APP2 (0xB7, VirtualKey.LAUNCH_APP2),
    // - (0xB8-B9, "Reserved"),
    // VK_OEM_1 (0xBA, "Used for miscellaneous characters; it can vary by keyboard." +
    // "For the US standard keyboard, the ';:' key"),
    VK_OEM_PLUS(0xBB, VirtualKey.PLUS), VK_OEM_COMMA(0xBC, VirtualKey.COMMA), VK_OEM_MINUS(0xBD,
        VirtualKey.MINUS), VK_OEM_PERIOD(0xBE, VirtualKey.PERIOD);
    // VK_OEM_2 (0xBF, "Used for miscellaneous characters; it can vary by keyboard." +
    // "For the US standard keyboard, the '/?' key"),
    // VK_OEM_3 (0xC0, "Used for miscellaneous characters; it can vary by keyboard." +
    // "For the US standard keyboard, the '`~' key"),
    // - (0xC1-D7, "ReserveD, "- (0xD8-DA, "Unassigned"),
    // VK_OEM_4 (0xDB, "Used for miscellaneous characters; it can vary by keyboard." +
    // "For the US standard keyboard, the '[{' key"),
    // VK_OEM_5 (0xDC, "Used for miscellaneous characters; it can vary by keyboard." +
    // "For the US standard keyboard, the '\\|' key"),
    // VK_OEM_6 (0xDD, "Used for miscellaneous characters; it can vary by keyboard." +
    // "For the US standard keyboard, the ']}' key"),
    // VK_OEM_7 (0xDE, "Used for miscellaneous characters; it can vary by keyboard." +
    // "For the US standard keyboard, the 'single-quote/double-quote' key"),
    // VK_OEM_8 (0xDF, "Used for miscellaneous characters; it can vary by keyboard."),
    // - (0xE0, "Reserved"),
    // - (0xE1, "OEM specific"),
    // VK_OEM_102 (0xE2, "Either the angle bracket key or the backslash key on the RT 102-key" +
    // "keyboard"),
    // - (0xE3-E4, "OEM specific"),
    // VK_PROCESSKEY (0xE5, VirtualKey.EXECUTE),
    // - (0xE6, "OEM specific"),
    // VK_PACKET (0xE7, "Used to pass Unicode characters as if they were keystrokes. The " +
    // "VK_PACKET key is the low word of a 32-bit Virtual Key value used for non-keyboard " +
    // "input methods. For more information, see Remark in KEYBDINPUT, SendInput, " +
    // "WM_KEYDOWN, and WM_KEYUP"),
    // - (0xE8, "Unassigned (0xE9-F5, "OEM specific"),
    // VK_ATTN (0xF6, "Attn key"),
    // VK_CRSEL (0xF7, "CrSel key"),
    // VK_EXSEL (0xF8, "ExSel key"),
    // VK_EREOF (0xF9, "Erase EOF key"),
    // VK_PLAY (0xFA, VirtualKey.MEDIA_PLAY_PAUSE);
    // VK_ZOOM (0xFB, "Zoom key"),
    // VK_NONAME (0xFC, "Reserved"),
    // VK_PA1 (0xFD, "PA1 key"),
    // VK_OEM_CLEAR (0xFE, "Clear key");

    /** the id of the virtual key */
    private int mNumber;

    /** the <code>Key</code> represented by this virtual key */
    private VirtualKey mRepresentedKey;

    // -----------------------------------------------------------------------------------------------
    /**
     * @param number
     */
    // -----------------------------------------------------------------------------------------------
    WindowsVirtualKey(int number, VirtualKey representedKey)
    {
        mNumber = number;
        mRepresentedKey = representedKey;
    }

    // -----------------------------------------------------------------------------------------------
    /**
     * @return Returns the number.
     */
    // -----------------------------------------------------------------------------------------------
    int getNumber()
    {
        return mNumber;
    }

    // -----------------------------------------------------------------------------------------------
    /**
   *
   */
    // -----------------------------------------------------------------------------------------------
    public static WindowsVirtualKey parseVirtualKey(String string)
    {
        for (WindowsVirtualKey virtualKey : WindowsVirtualKey.values())
        {
            if (virtualKey.mNumber == Integer.parseInt(string))
            {
                return virtualKey;
            }
        }

        throw new IllegalArgumentException("there is no virtual key with id " + string);
    }

    // -----------------------------------------------------------------------------------------------
    /**
   *
   */
    // -----------------------------------------------------------------------------------------------
    public static WindowsVirtualKey valueOf(int number)
    {
        for (WindowsVirtualKey virtualKey : WindowsVirtualKey.values())
        {
            if (virtualKey.mNumber == number)
            {
                return virtualKey;
            }
        }

        throw new IllegalArgumentException("there is no virtual key with number " + number);
    }

    // -----------------------------------------------------------------------------------------------
    /**
     * TODO: comment
     * 
     * @return
     */
    // -----------------------------------------------------------------------------------------------
    public VirtualKey getKey()
    {
        return mRepresentedKey;
    }

}
