
package de.ugoe.cs.quest.commands.sequences;

import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to condense the GUI model of a sequence, i.e., merge duplicate nodes.
 * </p>
 * 
 * @version 1.0
 * @author Steffen Herbold
 */
public class CMDcondenseGuiModel implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @Override
    public void run(List<Object> parameters) {
        String sequencesName = "sequences";

        if (parameters.size() > 0) {
            sequencesName = (String) parameters.get(0);
        }

        Object dataObject = GlobalDataContainer.getInstance().getData(sequencesName + "_targets");
        if (dataObject == null) {
            CommandHelpers.objectNotFoundMessage(sequencesName + "_targets");
            return;
        }
        if (!(dataObject instanceof GUIModel)) {
            CommandHelpers.objectNotType(sequencesName, "GUIModel");
            return;
        }

        GUIModel model = (GUIModel) dataObject;

        model.condenseModel();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "condenseGuiModel {<sequencesName>}";
    }

}
