/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import jdepend.framework.DependencyConstraint;
import jdepend.framework.JDepend;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageFilter;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class ExampleTest
extends TestCase {
    private JDepend jdepend;
    public String jdependHomeDirectory;
    static /* synthetic */ Class class$jdepend$framework$ExampleTest;

    public ExampleTest(String name) {
        super(name);
    }

    protected void setUp() throws IOException {
        this.jdependHomeDirectory = System.getProperty("jdepend.home");
        if (this.jdependHomeDirectory == null) {
            ExampleTest.fail((String)"Property 'jdepend.home' not defined");
        }
        PackageFilter filter = new PackageFilter();
        filter.addPackage("java.*");
        filter.addPackage("javax.*");
        this.jdepend = new JDepend(filter);
        String classesDir = this.jdependHomeDirectory + File.separator + "build";
        this.jdepend.addDirectory(classesDir);
    }

    public void testOnePackageDistance() {
        double ideal = 0.0;
        double tolerance = 0.8;
        this.jdepend.analyze();
        JavaPackage p = this.jdepend.getPackage("jdepend.framework");
        ExampleTest.assertEquals((String)("Distance exceeded: " + p.getName()), (double)ideal, (double)p.distance(), (double)tolerance);
    }

    public void testOnePackageHasNoCycles() {
        this.jdepend.analyze();
        JavaPackage p = this.jdepend.getPackage("jdepend.framework");
        ExampleTest.assertEquals((String)("Cycles exist: " + p.getName()), (boolean)false, (boolean)p.containsCycle());
    }

    public void testAllPackagesDistance() {
        double ideal = 0.0;
        double tolerance = 1.0;
        Collection packages = this.jdepend.analyze();
        Iterator iter = packages.iterator();
        while (iter.hasNext()) {
            JavaPackage p = (JavaPackage)iter.next();
            ExampleTest.assertEquals((String)("Distance exceeded: " + p.getName()), (double)ideal, (double)p.distance(), (double)tolerance);
        }
    }

    public void testAllPackagesHaveNoCycles() {
        Collection packages = this.jdepend.analyze();
        ExampleTest.assertEquals((String)"Cycles exist", (boolean)false, (boolean)this.jdepend.containsCycles());
    }

    public void testDependencyConstraint() {
        DependencyConstraint constraint = new DependencyConstraint();
        JavaPackage junitframework = constraint.addPackage("junit.framework");
        JavaPackage junitui = constraint.addPackage("junit.textui");
        JavaPackage framework = constraint.addPackage("jdepend.framework");
        JavaPackage text = constraint.addPackage("jdepend.textui");
        JavaPackage xml = constraint.addPackage("jdepend.xmlui");
        JavaPackage swing = constraint.addPackage("jdepend.swingui");
        framework.dependsUpon(junitframework);
        framework.dependsUpon(junitui);
        text.dependsUpon(framework);
        xml.dependsUpon(text);
        swing.dependsUpon(framework);
        this.jdepend.analyze();
        ExampleTest.assertEquals((String)"Constraint mismatch", (boolean)true, (boolean)this.jdepend.dependencyMatch(constraint));
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$jdepend$framework$ExampleTest == null ? (class$jdepend$framework$ExampleTest = ExampleTest.class$("jdepend.framework.ExampleTest")) : class$jdepend$framework$ExampleTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

