
package de.ugoe.cs.quest.eventcore.gui;

/**
 * <p>
 * Event type for pressing a mouse button.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class MouseButtonDown extends MouseButtonInteraction {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new {@link MouseButtonDown} event type.
     * </p>
     * 
     * @see MouseButtonInteraction#MouseButtonInteraction(Button)
     */
    public MouseButtonDown(Button button) {
        super(button);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#getName()
     */
    public String getName() {
        if (super.getButton() == Button.LEFT) {
            return "LeftMouseButtonDown";
        }
        else if (super.getButton() == Button.MIDDLE) {
            return "MiddleMouseButtonDown";
        }
        else if (super.getButton() == Button.RIGHT) {
            return "RightMouseButtonDown";
        }
        else {
            return "UnknownMouseButtonDown";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        if (super.getButton() == Button.LEFT) {
            return "left mouse button down";
        }
        else if (super.getButton() == Button.MIDDLE) {
            return "middle mouse button down";
        }
        else if (super.getButton() == Button.RIGHT) {
            return "right mouse button down";
        }
        else {
            return "unknown mouse button down";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#startsLogicalSequence()
     */
    public boolean startsLogicalSequence() {
        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#finishesLogicalSequence()
     */
    public boolean finishesLogicalSequence() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MouseButtonDown) {
            return getButton().equals(((MouseButtonDown) obj).getButton());
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return getButton().hashCode();
    }

}
