package de.ugoe.cs.quest.tasktrees.nodeequality;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.quest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNodeFactory;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeNodeFactory;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeNode;

/**
 * @author Patrick Harms
 */
public class NodeAndSelectionComparisonRuleTest {

    /**
     *
     */
    @Test
    public void test() {
        NodeEqualityRuleManager manager = new NodeEqualityRuleManager();
        manager.init();
        
        ITaskTreeNodeFactory treeNodeFactory = new TaskTreeNodeFactory();
        ITaskTreeBuilder treeBuilder = new TaskTreeBuilder();
        
        NodeAndSelectionComparisonRule rule = new NodeAndSelectionComparisonRule(manager);
        
        ITaskTreeNode task1 = new TaskTreeNode("task1");
        
        assertNull(rule.compare(task1, task1));
        
        ISelection selection1 = treeNodeFactory.createNewSelection();
        assertNull(rule.compare(selection1, selection1));
        assertNull(rule.compare(task1, selection1));
        assertNull(rule.compare(selection1, task1));

        treeBuilder.addChild(selection1, task1);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(selection1, task1));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(task1, selection1));
        
        selection1 = treeNodeFactory.createNewSelection();
        ISelection selection2 = treeNodeFactory.createNewSelection();
        treeBuilder.addChild(selection2, task1);
        treeBuilder.addChild(selection1, selection2);
        
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(selection1, task1));
        assertEquals(NodeEquality.LEXICALLY_EQUAL, rule.compare(task1, selection1));
    }

}
