
package de.ugoe.cs.quest.jfcmonitor;

import java.awt.AWTEvent;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;

/**
 * <p>
 * An AWT event listener responsible to monitor the window creation and destruction.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class WindowMonitor implements AWTEventListener {

    /**
     * <p>
     * Adds all created windows (and their child components) to the GUI hierarchy maintained by
     * {@link JFCComponent} and removes them if a window is destroyed.
     * </p>
     * </p>
     * 
     * @see java.awt.event.AWTEventListener#eventDispatched(java.awt.AWTEvent)
     */
    @Override
    public void eventDispatched(AWTEvent event) {
        Window window;
        switch (event.getID())
        {
            case WindowEvent.WINDOW_OPENED:
                window = ((WindowEvent) event).getWindow();
                JFCComponent.add(window);
                break;
            case WindowEvent.WINDOW_CLOSED:
                window = ((WindowEvent) event).getWindow();
                JFCComponent.remove(window);
                break;
            default:
                break;
        }
    }

}
