
package de.ugoe.cs.quest.plugin.jfc.guimodel;

import de.ugoe.cs.quest.eventcore.guimodel.AbstractDefaultGUIElement;
import de.ugoe.cs.quest.eventcore.guimodel.IGUIElementSpec;

/**
 * <p>
 * Base class for all JFC GUI elements.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class JFCGUIElement extends AbstractDefaultGUIElement {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Specification of the GUI Element
     * </p>
     */
    private JFCGUIElementSpec specification;

    /**
     * <p>
     * Constructor. Creates a new JFCGUIElement.
     * </p>
     * 
     * @param specification
     *            specification of created GUI element
     * @param parent
     *            parent of the created GUI element; null means that the element is a top-level
     *            window
     */
    public JFCGUIElement(JFCGUIElementSpec specification, JFCGUIElement parent) {
        super(specification, parent);
        this.specification = specification;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.quest.eventcore.IEventTarget#getPlatform()
     */
    @Override
    public String getPlatform() {
        return "JFC";
    }

    /**
     * <p>
     * Returns the type of the GUI element, i.e., the name of its Java class.
     * </p>
     * 
     * @return the Java class name
     */
    public String getJavaType() {
        return specification.getType();
    }

    /**
     * <p>
     * Returns the name of the GUI element.
     * </p>
     * 
     * @return the name
     */
    String getName() {
        return specification.getName();
    }

    /**
     * <p>
     * Returns the icon of the GUI element.
     * </p>
     * 
     * @return the icon
     */
    String getIcon() {
        return specification.getIcon();
    }

    /**
     * <p>
     * Returns the index of the GUI element.
     * </p>
     * 
     * @return the index
     */
    int getIndex() {
        return specification.getIndex();
    }

    /**
     * <p>
     * Returns the object hash of the GUI element.
     * </p>
     * 
     * @return the object hash
     */
    int getElementHash() {
        return specification.getElementHash();
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * de.ugoe.cs.quest.eventcore.guimodel.IGUIElement#updateSpecification(de.ugoe.cs.quest.eventcore
     * .guimodel.IGUIElementSpec)
     */
    @Override
    public void updateSpecification(IGUIElementSpec updateSpecification) {
        if (updateSpecification instanceof JFCGUIElementSpec) {
            specification.update(((JFCGUIElementSpec) updateSpecification));
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String getStringIdentifier() {
        String str = this.toString();
        if (getParent() != null) {
            return getParent().getStringIdentifier() + "->" + str;
        }
        return str;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String str =
            getElementDescriptor() + "(" + getName() + "," + getElementHash() + "," + getIcon() +
                "," + getIndex() + ")";
        return str;
    }

    /**
     * <p>
     * A short string describing the GUI element, e.g., Button, Canvas, or ScrollBar.
     * </p>
     * 
     * @return short element descriptor
     */
    protected String getElementDescriptor() {
        return "Default";
    }

}
