
package de.ugoe.cs.quest.eventcore.gui;

/**
 * <p>
 * Base class for all mouse interaction event types.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public abstract class MouseButtonInteraction extends MouseInteraction {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Describes the pressed mouse button.
     * </p>
     * 
     * @version 1.0
     * @author Patrick Harms
     */
    public static enum Button {
        LEFT, MIDDLE, RIGHT, X;
    }

    /**
     * <p>
     * The button used for mouse interaction
     * </p>
     */
    private Button button;

    /**
     * <p>
     * Constructor. Creates a new {@link MouseButtonInteraction}
     * </p>
     * 
     * @param button
     *            the button associated with the interaction
     */
    public MouseButtonInteraction(Button button) {
        this.button = button;
    }

    /**
     * <p>
     * Returns the button associated with the interaction.
     * </p>
     * 
     * @return the button
     */
    public Button getButton() {
        return button;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MouseButtonInteraction) {
            return getButton().equals(((MouseButtonInteraction) obj).getButton());
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return getButton().hashCode();
    }
}
