package de.ugoe.cs.util.console;

import java.util.List;

/**
 * <p>
 * Defines the interface for a command. The class names of the commands must be
 * of the form {@code CMD<commandname>}, otherwise they cannot be used by the
 * {@link CommandExecuter}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public interface Command {

	/**
	 * <p>
	 * Executes a command.
	 * </p>
	 * 
	 * @param parameters
	 *            parameters for the command.
	 */
	public void run(List<Object> parameters);

	/**
	 * <p>
	 * Returns a string the contains information about how to use the command.
	 * </p>
	 * @return help string
	 */
	public String help();
}
