/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class OpcodeStackScanner {
    public static OpcodeStack getStackAt(JavaClass theClass, Method method, int pc) {
        Scanner scanner = new Scanner(theClass, method, pc);
        try {
            scanner.execute();
        }
        catch (EarlyExitException e) {
            return e.stack;
        }
        throw new IllegalArgumentException("Didn't reach pc " + pc + " of " + method);
    }

    static class Scanner
    extends OpcodeStackDetector {
        final JavaClass theClass;
        final Method targetMethod;
        final int targetPC;

        Scanner(JavaClass theClass, Method targetMethod, int targetPC) {
            this.theClass = theClass;
            this.targetMethod = targetMethod;
            this.targetPC = targetPC;
        }

        public void sawOpcode(int seen) {
            if (this.getPC() == this.targetPC) {
                throw new EarlyExitException(this.stack);
            }
        }

        public void visitJavaClass(JavaClass obj) {
            this.setupVisitorForClass(obj);
            this.getConstantPool().accept(this);
            this.doVisitMethod(this.targetMethod);
        }

        public void execute() {
            this.theClass.accept(this);
        }
    }

    static class EarlyExitException
    extends RuntimeException {
        final OpcodeStack stack;

        public EarlyExitException(OpcodeStack stack) {
            this.stack = stack;
        }
    }
}

