
package de.ugoe.cs.quest.plugin.jfc.guimodel;

import de.ugoe.cs.quest.eventcore.guimodel.IMenuButton;

/**
 * <p>
 * Class that represents menu buttons in JFC GUIs.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class JFCMenuButton extends JFCButton implements IMenuButton {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new JFCMenuButton.
     * </p>
     * 
     * @param specification
     *            specification of created GUI element
     * @param parent
     *            parent of the created GUI element; null means that the element is a top-level
     *            window
     */
    public JFCMenuButton(JFCGUIElementSpec specification, JFCGUIElement parent) {
        super(specification, parent);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.quest.plugin.jfc.guimodel.JFCButton#getElementDescriptor()
     */
    @Override
    protected String getElementDescriptor() {
        return "MenuButton";
    }

}
