package de.ugoe.cs.quest.plugin.jfc;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.logging.Level;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.util.console.TextConsole;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public class JFCTraceCorrectorTest {

    /** */
    private File outputFile = new File("tmp_output.xml");
    
    /**
     *
     */
    @Before
    public void setUp() {
        new TextConsole(Level.FINEST);
    }

    /**
     *
     */
    @After
    public void tearDown() {
        if ((outputFile != null) && (outputFile.exists())) {
            outputFile.delete();
        }
    }

    /**
     *
     */
    @Test
    public void test() throws Exception {
        JFCTraceCorrector corrector = new JFCTraceCorrector();
        corrector.correctFile(getTestFile("uncorrected_trace.xml"), outputFile);
        
        BufferedReader reader1 = null;
        BufferedReader reader2 = null;

        try {
            reader1 = new BufferedReader(new FileReader(getTestFile("corrected_trace.xml")));
            reader2 = new BufferedReader(new FileReader(outputFile));
            
            String line;
            do {
                line = reader1.readLine();
                if (line != null) {
                    assertEquals(line, reader2.readLine());
                }
                else {
                    assertNull(reader2.readLine());
                }
            }
            while (line != null);
        }
        finally {
            if (reader1 != null) {
                reader1.close();
            }
            if (reader2 != null) {
                reader2.close();
            }
        }
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param string
     * @return
     */
    private File getTestFile(String name) {
        return new File(ClassLoader.getSystemResource(name).getFile());
    }

}
