/**
 * 
 */
package de.ugoe.cs.quest.jfcmonitor;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import de.ugoe.cs.util.StringTools;

/**
 * @author Fabian Glaser
 *
 */
public class NameChangeListener implements PropertyChangeListener {
	 /**
     * <p>
     * Writer for logging events.
     * </p>
     */
    final private JFCMonitorOutputWriter outputWriter;	
    
    public NameChangeListener(JFCMonitorOutputWriter outputWriter){
    	this.outputWriter = outputWriter;
    }
	
	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		if (evt.getPropertyName().equals("AccessibleName")){
			StringBuilder builder = new StringBuilder();
			builder.append("<componentNameChange hash=\"");
			outputWriter.write(evt.getSource().toString());
			if (JFCComponent.find((Component) evt.getSource()) == null)
					System.err.println("Quelle nicht bekannt");
			builder.append(Integer.toHexString(evt.getSource().hashCode()));
			builder.append("\" newName=\"" + evt.getNewValue());
			builder.append("\"/>" + StringTools.ENDLINE);
			outputWriter.write(builder.toString());
		}
			
	}
	
}
