
package de.ugoe.cs.quest.jfcmonitor;

import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;

/**
 * <p>
 * A ComponentListener responsible for monitoring adding and removing of GUI components
 * </p>
 * 
 * @author Fabian Glaser
 * @version 1.0
 */
public class JFCContainerListener implements ContainerListener {
	 /**
     * <p>
     * Writer for logging events.
     * </p>
     */
    final private JFCMonitorOutputWriter outputWriter;	
	
    /**
     * <p>
     * Constructor. Creates a new JFCContainerListener with a given {@link JFCMonitorOutputWriter}, where the
     * monitored information is logged.
     * </p>
     * 
     * @param outputWriter
     *            writer for the logged information
     */
    public JFCContainerListener(JFCMonitorOutputWriter outputWriter) {
        this.outputWriter = outputWriter;
    }

	@Override
	public void componentAdded(ContainerEvent e) {
		Component src = e.getChild();
		if (!JFCComponent.isKnown(src)){
			JFCComponent.add(src);
			JFCComponent jfcComponent = JFCComponent.find(src);
			outputWriter.write(jfcComponent.getXML());
			outputWriter.write(jfcComponent.printChildren());
		}		
	}

	@Override
	public void componentRemoved(ContainerEvent e) {
		//System.out.println("Component has been removed...");
	}

}