package de.ugoe.cs.quest.eventcore;

import java.io.Serializable;

import de.ugoe.cs.quest.IReplayDecorator;

/**
 * <p>
 * This interface is used by {@link ReplayableEvent}to describe how events can
 * be replayed. It can be used to define a sequence of fine-grained platform
 * events that make up an abstract event.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public interface IReplayable extends Serializable {

	/**
	 * <p>
	 * Returns a string to be written to the replay script that describes the
	 * replayable platform event.
	 * </p>
	 * 
	 * @return string for the replay script
	 */
	String getReplay();
	
	/**
	 * <p>
	 * Returns the replay decorator associated with the replayable. Returns null if no replay decorator is associated with the replayable.
	 * </p>
	 *
	 * @return replay decorator
	 */
	IReplayDecorator getDecorator();
}
