package de.ugoe.cs.quest.commands.misc;

import java.util.List;
import java.util.logging.Level;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to show the time elapsed since a timer has been started.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDshowTimer implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String timerName;
		try {
			timerName = (String) parameters.get(0);
		} catch (Exception e) {
			throw new IllegalArgumentException();
		}

		Object dataObject = GlobalDataContainer.getInstance().getData(timerName);
		if (dataObject == null) {
			CommandHelpers.objectNotFoundMessage(timerName);
			return;
		}
		if (!(dataObject instanceof Long)) {
			CommandHelpers.objectNotType(timerName, "Long");
			return;
		}

		long startTime = (Long) dataObject;
		long currentTime = System.currentTimeMillis();
		Console.traceln(Level.INFO, "" + (currentTime - startTime) + " milliseconds");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "showTimer <timerName>";
	}

}
